@extends('admin.layouts.main')

@section('title', 'Finance Report')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Finance Report</h1>
        <div class="d-flex">
            <button class="btn btn-success mr-2" onclick="exportToExcel()">
                <i class="fas fa-file-excel"></i> Export
            </button>
            <button class="btn btn-primary" onclick="printReport()">
                <i class="fas fa-print"></i> Print
            </button>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Period</h6>
        </div>
        <div class="card-body">
            <form id="filterForm" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="year">Year</label>
                            <select class="form-control" id="year" name="year">
                                @for($i = date('Y'); $i >= 2020; $i--)
                                    <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="month">Month</label>
                            <select class="form-control" id="month" name="month">
                                <option value="">All Months</option>
                                @foreach(['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'] as $index => $month)
                                    <option value="{{ $index + 1 }}">{{ $month }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="report_type">Report Type</label>
                            <select class="form-control" id="report_type" name="report_type">
                                <option value="income_statement">Income Statement</option>
                                <option value="balance_sheet">Balance Sheet</option>
                                <option value="cash_flow">Cash Flow</option>
                                <option value="profit_loss">Profit & Loss</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-filter"></i> Generate Report
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Financial Summary -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Revenue
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format(isset($apiData['total_revenue']) ? $apiData['total_revenue'] : 0, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Net Profit
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format(isset($apiData['net_profit']) ? $apiData['net_profit'] : 0, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Operating Costs
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format(isset($apiData['operating_costs']) ? $apiData['operating_costs'] : 0, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Gross Margin
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ isset($apiData['gross_margin']) ? number_format($apiData['gross_margin'], 1) : 0 }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-percentage fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Income Statement -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Income Statement</h6>
            <span class="text-muted">Period: {{ date('F Y') }}</span>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th>Description</th>
                            <th>Amount (Rp)</th>
                            <th>Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="table-light">
                            <td><strong>Revenue</strong></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Food Sales</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['food_sales']) ? $apiData['food_sales'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['food_sales_percentage']) ? number_format($apiData['food_sales_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Beverage Sales</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['beverage_sales']) ? $apiData['beverage_sales'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['beverage_sales_percentage']) ? number_format($apiData['beverage_sales_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr class="table-light">
                            <td><strong>Total Revenue</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['total_revenue']) ? $apiData['total_revenue'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>100%</strong></td>
                        </tr>
                        
                        <tr class="table-light">
                            <td><strong>Cost of Goods Sold</strong></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Food Costs</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['food_costs']) ? $apiData['food_costs'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['food_costs_percentage']) ? number_format($apiData['food_costs_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Beverage Costs</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['beverage_costs']) ? $apiData['beverage_costs'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['beverage_costs_percentage']) ? number_format($apiData['beverage_costs_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr class="table-light">
                            <td><strong>Total COGS</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['total_cogs']) ? $apiData['total_cogs'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>{{ isset($apiData['cogs_percentage']) ? number_format($apiData['cogs_percentage'], 1) : 0 }}%</strong></td>
                        </tr>
                        
                        <tr class="table-light">
                            <td><strong>Gross Profit</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['gross_profit']) ? $apiData['gross_profit'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>{{ isset($apiData['gross_profit_percentage']) ? number_format($apiData['gross_profit_percentage'], 1) : 0 }}%</strong></td>
                        </tr>
                        
                        <tr class="table-light">
                            <td><strong>Operating Expenses</strong></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Salaries & Wages</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['salary_expense']) ? $apiData['salary_expense'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['salary_percentage']) ? number_format($apiData['salary_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Rent & Utilities</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['rent_expense']) ? $apiData['rent_expense'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['rent_percentage']) ? number_format($apiData['rent_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Marketing</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['marketing_expense']) ? $apiData['marketing_expense'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['marketing_percentage']) ? number_format($apiData['marketing_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr class="table-light">
                            <td><strong>Total Operating Expenses</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['total_operating_expenses']) ? $apiData['total_operating_expenses'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>{{ isset($apiData['operating_expenses_percentage']) ? number_format($apiData['operating_expenses_percentage'], 1) : 0 }}%</strong></td>
                        </tr>
                        
                        <tr class="table-success">
                            <td><strong>Net Profit Before Tax</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['net_profit_before_tax']) ? $apiData['net_profit_before_tax'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>{{ isset($apiData['net_profit_percentage']) ? number_format($apiData['net_profit_percentage'], 1) : 0 }}%</strong></td>
                        </tr>
                        <tr>
                            <td>&nbsp;&nbsp;Tax (10%)</td>
                            <td class="text-right">Rp {{ number_format(isset($apiData['tax']) ? $apiData['tax'] : 0, 0, ',', '.') }}</td>
                            <td class="text-right">{{ isset($apiData['tax_percentage']) ? number_format($apiData['tax_percentage'], 1) : 0 }}%</td>
                        </tr>
                        <tr class="table-success">
                            <td><strong>Net Profit After Tax</strong></td>
                            <td class="text-right"><strong>Rp {{ number_format(isset($apiData['net_profit_after_tax']) ? $apiData['net_profit_after_tax'] : 0, 0, ',', '.') }}</strong></td>
                            <td class="text-right"><strong>{{ isset($apiData['net_profit_after_tax_percentage']) ? number_format($apiData['net_profit_after_tax_percentage'], 1) : 0 }}%</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Expense Breakdown -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Expense Breakdown</h6>
                </div>
                <div class="card-body">
                    <canvas id="expenseChart"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Monthly Trend</h6>
                </div>
                <div class="card-body">
                    <canvas id="monthlyTrendChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Transactions -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Recent Financial Transactions</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="financeTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Transaction ID</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Amount (Rp)</th>
                            <th>Balance</th>
                            <th>Category</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($apiData['transactions']) && count($apiData['transactions']) > 0)
                            @foreach($apiData['transactions'] as $transaction)
                            <tr>
                                <td>{{ date('d/m/Y', strtotime($transaction['date'])) }}</td>
                                <td>#{{ $transaction['id'] }}</td>
                                <td>
                                    <span class="badge bg-{{ $transaction['type'] == 'income' ? 'success' : 'danger' }}">
                                        {{ ucfirst($transaction['type']) }}
                                    </span>
                                </td>
                                <td>{{ $transaction['description'] }}</td>
                                <td class="{{ $transaction['type'] == 'income' ? 'text-success' : 'text-danger' }}">
                                    {{ $transaction['type'] == 'income' ? '+' : '-' }} 
                                    Rp {{ number_format($transaction['amount'], 0, ',', '.') }}
                                </td>
                                <td>Rp {{ number_format($transaction['balance'], 0, ',', '.') }}</td>
                                <td>
                                    <span class="badge bg-secondary">{{ $transaction['category'] }}</span>
                                </td>
                            </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="7" class="text-center">No transactions available</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize DataTable
        $('#financeTable').DataTable({
            pageLength: 25,
            order: [[0, 'desc']],
            responsive: true
        });

        // Expense Breakdown Chart
        const expenseCtx = document.getElementById('expenseChart').getContext('2d');
        new Chart(expenseCtx, {
            type: 'doughnut',
            data: {
                labels: ['Salaries', 'Rent & Utilities', 'Ingredients', 'Marketing', 'Equipment', 'Other'],
                datasets: [{
                    data: [45, 20, 15, 10, 5, 5],
                    backgroundColor: [
                        '#4e73df',
                        '#1cc88a',
                        '#36b9cc',
                        '#f6c23e',
                        '#e74a3b',
                        '#858796'
                    ]
                }]
            },
            options: {
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });

        // Monthly Trend Chart
        const monthlyCtx = document.getElementById('monthlyTrendChart').getContext('2d');
        new Chart(monthlyCtx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    label: 'Revenue',
                    data: [12000000, 13500000, 15000000, 12500000, 14000000, 16000000, 18000000, 17500000, 19000000, 21000000, 20000000, 22000000],
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    fill: true,
                    tension: 0.4
                }, {
                    label: 'Expenses',
                    data: [8000000, 8500000, 9000000, 8700000, 9200000, 9500000, 10000000, 9800000, 10500000, 11000000, 10800000, 11500000],
                    borderColor: '#e74a3b',
                    backgroundColor: 'rgba(231, 74, 59, 0.1)',
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'Rp ' + (value / 1000000).toFixed(1) + 'M';
                            }
                        }
                    }
                }
            }
        });
    });

    function exportToExcel() {
        alert('Excel export functionality would be implemented here');
    }

    function printReport() {
        window.print();
    }
</script>
@endsection