{{-- resources/views/admin/promos/show.blade.php --}}
@extends('layouts.admin')

@section('title', 'Promotion Details')
@section('page_title', 'Promotion Details')
@section('icon', 'fa-tag')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.promos.index') }}">Promo Management</a></li>
    <li class="breadcrumb-item active">{{ $promo['name'] }}</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <!-- Promotion Details -->
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-tag me-2"></i>Promotion Details
                        </h5>
                        <div>
                            @if($promo['is_active'])
                                <span class="badge bg-success">
                                    <i class="fas fa-check-circle me-1"></i> Active
                                </span>
                            @else
                                <span class="badge bg-secondary">
                                    <i class="fas fa-times-circle me-1"></i> Inactive
                                </span>
                            @endif
                            
                            @php
                                $now = time();
                                $startDate = strtotime($promo['start_date']);
                                $endDate = strtotime($promo['end_date']);
                            @endphp
                            
                            @if($endDate < $now)
                                <span class="badge bg-danger ms-2">
                                    <i class="fas fa-clock me-1"></i> Expired
                                </span>
                            @elseif($startDate > $now)
                                <span class="badge bg-warning ms-2">
                                    <i class="fas fa-clock me-1"></i> Upcoming
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h4 class="mb-3">{{ $promo['name'] }}</h4>
                            
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="text-muted">Promo Code</label>
                                        <div class="d-flex align-items-center">
                                            @if($promo['code'])
                                                <code class="bg-light px-3 py-2 rounded font-monospace fs-5">
                                                    {{ $promo['code'] }}
                                                </code>
                                                <button type="button" class="btn btn-sm btn-outline-info ms-2" 
                                                        onclick="copyPromoCode()">
                                                    <i class="fas fa-copy me-1"></i> Copy
                                                </button>
                                            @else
                                                <span class="text-muted">Auto-apply promotion</span>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Discount Type</label>
                                        <p class="fs-5">
                                            @php
                                                $typeColors = [
                                                    'percentage' => 'primary',
                                                    'fixed' => 'success', 
                                                    'bogo' => 'warning'
                                                ];
                                                $typeColor = $typeColors[$promo['type']] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $typeColor }} fs-6">
                                                {{ ucfirst($promo['type']) }} Discount
                                            </span>
                                        </p>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Discount Value</label>
                                        <p class="fs-4 fw-bold text-primary">
                                            @if($promo['type'] == 'percentage')
                                                {{ $promo['discount_value'] }}%
                                            @elseif($promo['type'] == 'fixed')
                                                Rp {{ number_format($promo['discount_value'], 0, ',', '.') }}
                                            @else
                                                Buy One Get One
                                            @endif
                                        </p>
                                        @if($promo['max_discount'])
                                            <p class="text-muted">
                                                Maximum discount: Rp {{ number_format($promo['max_discount'], 0, ',', '.') }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="text-muted">Validity Period</label>
                                        <p class="fs-5 fw-bold">
                                            {{ date('d M Y', strtotime($promo['start_date'])) }} 
                                            <span class="text-muted">to</span> 
                                            {{ date('d M Y', strtotime($promo['end_date'])) }}
                                        </p>
                                        
                                        @php
                                            $totalDays = \Carbon\Carbon::parse($promo['start_date'])->diffInDays($promo['end_date']);
                                            $daysPassed = min(max(\Carbon\Carbon::parse($promo['start_date'])->diffInDays(now()), 0), $totalDays);
                                            $percentage = $totalDays > 0 ? ($daysPassed / $totalDays) * 100 : 100;
                                            
                                            $statusText = '';
                                            $statusColor = 'success';
                                            
                                            if($endDate < $now) {
                                                $statusText = 'Expired ' . \Carbon\Carbon::parse($promo['end_date'])->diffForHumans();
                                                $statusColor = 'danger';
                                            } elseif($startDate > $now) {
                                                $statusText = 'Starts in ' . \Carbon\Carbon::parse($promo['start_date'])->diffForHumans();
                                                $statusColor = 'warning';
                                            } else {
                                                $statusText = 'Ends in ' . \Carbon\Carbon::parse($promo['end_date'])->diffForHumans();
                                                $statusColor = 'success';
                                            }
                                        @endphp
                                        
                                        <div class="progress mb-2" style="height: 8px;">
                                            <div class="progress-bar bg-{{ $statusColor }}" 
                                                 role="progressbar" 
                                                 style="width: {{ min($percentage, 100) }}%"></div>
                                        </div>
                                        <small class="text-{{ $statusColor }}">
                                            <i class="fas fa-info-circle me-1"></i> {{ $statusText }}
                                        </small>
                                    </div>
                                    
                                    @if($promo['min_purchase'])
                                        <div class="mb-3">
                                            <label class="text-muted">Minimum Purchase</label>
                                            <p class="fs-5">
                                                Rp {{ number_format($promo['min_purchase'], 0, ',', '.') }}
                                            </p>
                                        </div>
                                    @endif
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Created On</label>
                                        <p class="text-muted">
                                            {{ date('d M Y, H:i', strtotime($promo['created_at'])) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            @if($promo['description'])
                                <div class="mb-3">
                                    <label class="text-muted">Description</label>
                                    <div class="border rounded p-3 bg-light">
                                        {{ $promo['description'] }}
                                    </div>
                                </div>
                            @endif
                        </div>
                        
                        <div class="col-md-4">
                            <!-- Statistics Card -->
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title border-bottom pb-2 mb-3">
                                        <i class="fas fa-chart-bar me-2"></i>Usage Statistics
                                    </h6>
                                    
                                    <div class="text-center mb-4">
                                        <div class="display-4 fw-bold text-primary">
                                            {{ $promo['usage_count'] ?? 0 }}
                                        </div>
                                        <div class="text-muted">Total Uses</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Total Discount Given</label>
                                        <p class="fs-4 fw-bold text-success">
                                            Rp {{ number_format($promo['total_discount_given'] ?? 0, 0, ',', '.') }}
                                        </p>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Average per Use</label>
                                        <p class="fs-5 text-info">
                                            Rp {{ number_format($promo['average_discount'] ?? 0, 0, ',', '.') }}
                                        </p>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Last Used</label>
                                        <p class="text-muted">
                                            @if($promo['last_used'] ?? false)
                                                {{ date('d M Y, H:i', strtotime($promo['last_used'])) }}
                                            @else
                                                <span class="text-muted">Never used</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Recent Usage (Optional) -->
            @if(isset($promo['recent_usage']) && count($promo['recent_usage']) > 0)
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-history me-2"></i>Recent Usage
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Order ID</th>
                                        <th>Customer</th>
                                        <th>Order Total</th>
                                        <th>Discount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($promo['recent_usage'] as $usage)
                                    <tr>
                                        <td>{{ date('d M Y, H:i', strtotime($usage['created_at'])) }}</td>
                                        <td>
                                            <a href="{{ route('employee.orders.show', $usage['order_id']) }}" 
                                               class="text-decoration-none" target="_blank">
                                                #{{ $usage['order_id'] }}
                                            </a>
                                        </td>
                                        <td>{{ $usage['customer_name'] }}</td>
                                        <td>Rp {{ number_format($usage['order_total'], 0, ',', '.') }}</td>
                                        <td class="text-success">
                                            -Rp {{ number_format($usage['discount_amount'], 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif
        </div>
        
        <div class="col-lg-4">
            <!-- Actions Card -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-cogs me-2"></i>Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.promos.edit', $promo['id']) }}" 
                           class="btn btn-warning">
                            <i class="fas fa-edit me-1"></i> Edit Promotion
                        </a>
                        
                        <form action="{{ route('admin.promos.toggle_active', $promo['id']) }}" 
                              method="POST" class="d-grid">
                            @csrf
                            @method('PUT')
                            <button type="submit" 
                                    class="btn btn-{{ $promo['is_active'] ? 'secondary' : 'success' }}">
                                <i class="fas fa-{{ $promo['is_active'] ? 'times' : 'check' }} me-1"></i>
                                {{ $promo['is_active'] ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>
                        
                        <button type="button" class="btn btn-danger" 
                                onclick="confirmDelete('delete-promo-{{ $promo['id'] }}')">
                            <i class="fas fa-trash me-1"></i> Delete Promotion
                        </button>
                        
                        <form id="delete-promo-{{ $promo['id'] }}" 
                              action="{{ route('admin.promos.destroy', $promo['id']) }}" 
                              method="POST" style="display: none;">
                            @csrf
                            @method('DELETE')
                        </form>
                        
                        <a href="{{ route('admin.promos.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Quick Stats -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2"></i>Quick Stats
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Today's Uses</span>
                            <span class="badge bg-primary rounded-pill">{{ $promo['today_uses'] ?? 0 }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>This Week</span>
                            <span class="badge bg-primary rounded-pill">{{ $promo['week_uses'] ?? 0 }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>This Month</span>
                            <span class="badge bg-primary rounded-pill">{{ $promo['month_uses'] ?? 0 }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Unique Customers</span>
                            <span class="badge bg-success rounded-pill">{{ $promo['unique_customers'] ?? 0 }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Success Rate</span>
                            <span class="badge bg-info rounded-pill">{{ number_format($promo['success_rate'] ?? 100, 1) }}%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function copyPromoCode() {
        const promoCode = "{{ $promo['code'] ?? '' }}";
        if (promoCode) {
            navigator.clipboard.writeText(promoCode).then(function() {
                alert('Promo code copied to clipboard: ' + promoCode);
            }).catch(function(err) {
                console.error('Failed to copy promo code: ', err);
                // Fallback method
                const textArea = document.createElement('textarea');
                textArea.value = promoCode;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                alert('Promo code copied to clipboard: ' + promoCode);
            });
        }
    }
    
    function confirmDelete(formId) {
        if (confirm('Are you sure you want to delete this promotion? This action cannot be undone.')) {
            document.getElementById(formId).submit();
        }
    }
</script>
@endsection