{{-- resources/views/admin/promos/index.blade.php --}}
@extends('layouts.admin')

@section('title', 'Promo Management')
@section('page_title', 'Promo Management')
@section('icon', 'fa-tags')

@section('breadcrumb')
    <li class="breadcrumb-item active">Promo Management</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-tags me-2"></i>Promotions
                        </h5>
                        <a href="{{ route('admin.promos.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New Promo
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('admin.promos.index') }}" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search" class="form-label">Search</label>
                                    <input type="text" class="form-control form-control-sm" 
                                           id="search" name="search" 
                                           value="{{ request('search') }}" 
                                           placeholder="Name or code...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="type" class="form-label">Type</label>
                                    <select class="form-control form-control-sm" id="type" name="type">
                                        <option value="">All Types</option>
                                        <option value="percentage" {{ request('type') == 'percentage' ? 'selected' : '' }}>
                                            Percentage
                                        </option>
                                        <option value="fixed" {{ request('type') == 'fixed' ? 'selected' : '' }}>
                                            Fixed Amount
                                        </option>
                                        <option value="bogo" {{ request('type') == 'bogo' ? 'selected' : '' }}>
                                            Buy One Get One
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select class="form-control form-control-sm" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" {{ request('is_active') == '1' ? 'selected' : '' }}>
                                            Active
                                        </option>
                                        <option value="0" {{ request('is_active') == '0' ? 'selected' : '' }}>
                                            Inactive
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <div class="d-flex gap-2 w-100">
                                    <button type="submit" class="btn btn-primary btn-sm flex-grow-1">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                    <a href="{{ route('admin.promos.index') }}" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-redo"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Promotions Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Type</th>
                                    <th>Discount Value</th>
                                    <th>Validity Period</th>
                                    <th>Usage</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($promos as $index => $promo)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <strong>{{ $promo['name'] }}</strong>
                                        @if($promo['description'])
                                            <br>
                                            <small class="text-muted">{{ Str::limit($promo['description'], 50) }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($promo['code'])
                                            <code class="bg-light px-2 py-1 rounded">{{ $promo['code'] }}</code>
                                        @else
                                            <span class="text-muted">Auto-apply</span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $typeColors = [
                                                'percentage' => 'primary',
                                                'fixed' => 'success', 
                                                'bogo' => 'warning'
                                            ];
                                            $typeColor = $typeColors[$promo['type']] ?? 'secondary';
                                        @endphp
                                        <span class="badge bg-{{ $typeColor }}">
                                            {{ ucfirst($promo['type']) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($promo['type'] == 'percentage')
                                            <strong>{{ $promo['discount_value'] }}%</strong>
                                        @elseif($promo['type'] == 'fixed')
                                            <strong>Rp {{ number_format($promo['discount_value'], 0, ',', '.') }}</strong>
                                        @else
                                            <span class="text-warning">BOGO</span>
                                        @endif
                                        @if($promo['max_discount'])
                                            <br>
                                            <small class="text-muted">
                                                Max: Rp {{ number_format($promo['max_discount'], 0, ',', '.') }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div>{{ date('d M Y', strtotime($promo['start_date'])) }}</div>
                                            <div class="text-muted">to</div>
                                            <div>{{ date('d M Y', strtotime($promo['end_date'])) }}</div>
                                            @if(strtotime($promo['end_date']) < time())
                                                <span class="badge bg-danger mt-1">Expired</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div>
                                                <i class="fas fa-fire text-warning me-1"></i>
                                                {{ $promo['usage_count'] ?? 0 }} uses
                                            </div>
                                            @if($promo['min_purchase'])
                                                <div class="text-muted">
                                                    Min: Rp {{ number_format($promo['min_purchase'], 0, ',', '.') }}
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        @if($promo['is_active'])
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i> Active
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-times-circle me-1"></i> Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('admin.promos.show', $promo['id']) }}" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.promos.edit', $promo['id']) }}" 
                                               class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger" 
                                                    onclick="confirmDelete('delete-promo-{{ $promo['id'] }}')"
                                                    data-bs-toggle="tooltip" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form action="{{ route('admin.promos.toggle_active', $promo['id']) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" 
                                                        class="btn btn-{{ $promo['is_active'] ? 'secondary' : 'success' }}"
                                                        data-bs-toggle="tooltip" 
                                                        title="{{ $promo['is_active'] ? 'Deactivate' : 'Activate' }}">
                                                    <i class="fas fa-{{ $promo['is_active'] ? 'times' : 'check' }}"></i>
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <form id="delete-promo-{{ $promo['id'] }}" 
                                              action="{{ route('admin.promos.destroy', $promo['id']) }}" 
                                              method="POST" style="display: none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-tags fa-3x mb-3"></i>
                                            <h5>No promotions found</h5>
                                            <p>Try adjusting your search filters or add new promotions</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($pagination))
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing {{ $pagination['from'] ?? 0 }} to 
                                {{ $pagination['to'] ?? 0 }} of 
                                {{ $pagination['total'] ?? 0 }} entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    {{-- Previous Page Link --}}
                                    @if(isset($pagination['current_page']) && $pagination['current_page'] > 1)
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1]) }}">
                                                &laquo;
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link">&laquo;</span>
                                        </li>
                                    @endif

                                    {{-- Page Numbers --}}
                                    @if(isset($pagination['last_page']))
                                        @php
                                            $currentPage = $pagination['current_page'] ?? 1;
                                            $lastPage = $pagination['last_page'] ?? 1;
                                            $startPage = max(1, $currentPage - 2);
                                            $endPage = min($lastPage, $currentPage + 2);
                                        @endphp
                                        
                                        @for($i = $startPage; $i <= $endPage; $i++)
                                            @if($i == $currentPage)
                                                <li class="page-item active">
                                                    <span class="page-link">{{ $i }}</span>
                                                </li>
                                            @else
                                                <li class="page-item">
                                                    <a class="page-link" 
                                                       href="{{ request()->fullUrlWithQuery(['page' => $i]) }}">
                                                        {{ $i }}
                                                    </a>
                                                </li>
                                            @endif
                                        @endfor
                                    @endif

                                    {{-- Next Page Link --}}
                                    @if(isset($pagination['current_page']) && isset($pagination['last_page']) && 
                                        $pagination['current_page'] < $pagination['last_page'])
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1]) }}">
                                                &raquo;
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link">&raquo;</span>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[5, 'desc']], // Sort by validity date
            columnDefs: [
                { orderable: false, targets: [8] } // Disable sorting for actions column
            ]
        });
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
    
    function confirmDelete(formId) {
        if (confirm('Are you sure you want to delete this promotion?')) {
            document.getElementById(formId).submit();
        }
    }
</script>
@endsection