{{-- resources/views/admin/promos/edit.blade.php --}}
@extends('layouts.admin')

@section('title', 'Edit Promotion')
@section('page_title', 'Edit Promotion')
@section('icon', 'fa-edit')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.promos.index') }}">Promo Management</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.promos.show', $promo['id']) }}">{{ $promo['name'] }}</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-edit me-2"></i>Edit Promotion: {{ $promo['name'] }}
                        </h5>
                        <a href="{{ route('admin.promos.show', $promo['id']) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left me-1"></i> Cancel
                        </a>
                    </div>
                </div>
                
                <form action="{{ route('admin.promos.update', $promo['id']) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">
                                            <i class="fas fa-info-circle me-2"></i>Basic Information
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label for="name" class="form-label">Promotion Name *</label>
                                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                       id="name" name="name" 
                                                       value="{{ old('name', $promo['name']) }}" required>
                                                @error('name')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="type" class="form-label">Discount Type *</label>
                                                <select class="form-control @error('type') is-invalid @enderror" 
                                                        id="type" name="type" required>
                                                    <option value="">Select Type</option>
                                                    <option value="percentage" {{ old('type', $promo['type']) == 'percentage' ? 'selected' : '' }}>
                                                        Percentage Discount
                                                    </option>
                                                    <option value="fixed" {{ old('type', $promo['type']) == 'fixed' ? 'selected' : '' }}>
                                                        Fixed Amount Discount
                                                    </option>
                                                    <option value="bogo" {{ old('type', $promo['type']) == 'bogo' ? 'selected' : '' }}>
                                                        Buy One Get One (BOGO)
                                                    </option>
                                                </select>
                                                @error('type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="discount_value" class="form-label">Discount Value *</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control @error('discount_value') is-invalid @enderror" 
                                                           id="discount_value" name="discount_value" 
                                                           value="{{ old('discount_value', $promo['discount_value']) }}" 
                                                           min="0" step="0.01" required>
                                                    <span class="input-group-text" id="discount_suffix">
                                                        {{ $promo['type'] == 'percentage' ? '%' : ($promo['type'] == 'fixed' ? 'Rp' : '') }}
                                                    </span>
                                                    @error('discount_value')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                                <small class="form-text text-muted" id="discount_hint">
                                                    @if($promo['type'] == 'percentage')
                                                        Enter percentage (e.g., 10 for 10%)
                                                    @elseif($promo['type'] == 'fixed')
                                                        Enter fixed amount (e.g., 5000 for Rp 5,000)
                                                    @else
                                                        Buy One Get One - No value needed
                                                    @endif
                                                </small>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="code" class="form-label">Promo Code</label>
                                                <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                                       id="code" name="code" 
                                                       value="{{ old('code', $promo['code']) }}" 
                                                       placeholder="e.g., SUMMER2024">
                                                @error('code')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                                <small class="form-text text-muted">
                                                    Leave blank for auto-apply promotions
                                                </small>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="max_discount" class="form-label">Maximum Discount (Rp)</label>
                                                <input type="number" class="form-control @error('max_discount') is-invalid @enderror" 
                                                       id="max_discount" name="max_discount" 
                                                       value="{{ old('max_discount', $promo['max_discount']) }}" 
                                                       min="0" step="1000" placeholder="Optional">
                                                @error('max_discount')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                                <small class="form-text text-muted">
                                                    Maximum discount amount (for percentage discounts)
                                                </small>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="description" class="form-label">Description</label>
                                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                                      id="description" name="description" rows="3">{{ old('description', $promo['description']) }}</textarea>
                                            @error('description')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <!-- Validity Period -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">
                                            <i class="fas fa-calendar me-2"></i>Validity Period
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="start_date" class="form-label">Start Date *</label>
                                            <input type="date" class="form-control @error('start_date') is-invalid @enderror" 
                                                   id="start_date" name="start_date" 
                                                   value="{{ old('start_date', $promo['start_date']) }}" required>
                                            @error('start_date')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="end_date" class="form-label">End Date *</label>
                                            <input type="date" class="form-control @error('end_date') is-invalid @enderror" 
                                                   id="end_date" name="end_date" 
                                                   value="{{ old('end_date', $promo['end_date']) }}" required>
                                            @error('end_date')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="min_purchase" class="form-label">Minimum Purchase (Rp)</label>
                                            <input type="number" class="form-control @error('min_purchase') is-invalid @enderror" 
                                                   id="min_purchase" name="min_purchase" 
                                                   value="{{ old('min_purchase', $promo['min_purchase']) }}" 
                                                   min="0" step="1000" placeholder="Optional">
                                            @error('min_purchase')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Minimum order amount to apply this promo
                                            </small>
                                        </div>
                                        
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="is_active" name="is_active" value="1" 
                                                   {{ old('is_active', $promo['is_active']) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_active">
                                                Active Promotion
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Statistics -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">
                                            <i class="fas fa-chart-bar me-2"></i>Statistics
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="alert alert-info mb-0">
                                            <h6 class="alert-heading">Current Stats</h6>
                                            <hr class="my-2">
                                            <p class="mb-1">
                                                <strong>Total Uses:</strong> 
                                                {{ $promo['usage_count'] ?? 0 }}
                                            </p>
                                            <p class="mb-1">
                                                <strong>Total Discount:</strong> 
                                                Rp {{ number_format($promo['total_discount_given'] ?? 0, 0, ',', '.') }}
                                            </p>
                                            <p class="mb-0">
                                                <strong>Last Used:</strong> 
                                                @if($promo['last_used'] ?? false)
                                                    {{ date('d M Y', strtotime($promo['last_used'])) }}
                                                @else
                                                    <span class="text-muted">Never used</span>
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer">
                        <div class="d-flex justify-content-between">
                            <div>
                                <a href="{{ route('admin.promos.show', $promo['id']) }}" class="btn btn-secondary me-2">
                                    <i class="fas fa-times me-1"></i> Cancel
                                </a>
                                <a href="{{ route('admin.promos.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-list me-1"></i> Back to List
                                </a>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Update Promotion
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const typeSelect = document.getElementById('type');
        const discountValueInput = document.getElementById('discount_value');
        const discountSuffix = document.getElementById('discount_suffix');
        const discountHint = document.getElementById('discount_hint');
        const startDateInput = document.getElementById('start_date');
        const endDateInput = document.getElementById('end_date');
        
        // Handle discount type change
        typeSelect.addEventListener('change', function() {
            const type = this.value;
            let suffix = '%';
            let hint = 'Enter percentage (e.g., 10 for 10%)';
            
            if (type === 'fixed') {
                suffix = 'Rp';
                hint = 'Enter fixed amount (e.g., 5000 for Rp 5,000)';
            } else if (type === 'bogo') {
                suffix = '';
                discountValueInput.value = '';
                discountValueInput.disabled = true;
                hint = 'Buy One Get One - No value needed';
            } else {
                discountValueInput.disabled = false;
            }
            
            discountSuffix.textContent = suffix;
            discountHint.textContent = hint;
        });
        
        // Set min date for end date
        startDateInput.addEventListener('change', function() {
            endDateInput.min = this.value;
        });
        
        // Set max date for start date
        endDateInput.addEventListener('change', function() {
            startDateInput.max = this.value;
        });
    });
</script>
@endsection