@extends('admin.layouts.main')

@section('title', 'Payment Methods')
@section('page-title', 'Payment Methods')

@section('breadcrumbs')
    <li class="breadcrumb-item active">Payment Methods</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $totalMethods ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-credit-card fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $activeMethods ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Digital Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $digitalMethods ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-mobile-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Most Used Method
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ ucfirst(str_replace('_', ' ', $mostUsedMethod)) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-pie fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Payment Methods</h6>
                    <a href="{{ route('admin.payment-methods.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add New Method
                    </a>
                </div>
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('admin.payment-methods.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search">Search</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="{{ request('search') }}" placeholder="Search by name...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="code">Type</label>
                                    <select class="form-control" id="code" name="code">
                                        <option value="">All Types</option>
                                        @foreach($codes as $code)
                                            <option value="{{ $code }}" {{ request('code') == $code ? 'selected' : '' }}>
                                                {{ ucfirst(str_replace('_', ' ', $code)) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <select class="form-control" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" {{ request('is_active') == '1' ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ request('is_active') == '0' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Payment Methods Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Account Details</th>
                                    <th>Instructions</th>
                                    <th>Status</th>
                                    <th>Usage</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($paymentMethods as $index => $method)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <strong>{{ $method['name'] }}</strong>
                                        <br>
                                        <small class="text-muted">
                                            {{ $method['account_name'] ? 'Account: ' . $method['account_name'] : '' }}
                                            {{ $method['account_number'] ? ' | ' . $method['account_number'] : '' }}
                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ getPaymentMethodColor($method['code']) }}">
                                            {{ ucfirst(str_replace('_', ' ', $method['code'])) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($method['account_number'])
                                            <small>
                                                <strong>Number:</strong> {{ $method['account_number'] }}<br>
                                                <strong>Name:</strong> {{ $method['account_name'] ?? 'N/A' }}
                                            </small>
                                        @else
                                            <span class="text-muted">No account details</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($method['instructions'])
                                            <small>{{ Str::limit($method['instructions'], 50) }}</small>
                                        @else
                                            <span class="text-muted">No instructions</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $method['is_active'] ? 'success' : 'danger' }}">
                                            {{ $method['is_active'] ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <small>
                                            <strong>Total:</strong> {{ $method['total_transactions'] ?? 0 }}<br>
                                            <strong>Success:</strong> {{ number_format($method['success_rate'] ?? 100, 1) }}%
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.payment-methods.show', $method['id']) }}" 
                                               class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.payment-methods.edit', $method['id']) }}" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.payment-methods.destroy', $method['id']) }}" 
                                                  method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Are you sure you want to delete this payment method?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">No payment methods found</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($pagination)
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing {{ ($pagination['current_page'] - 1) * $pagination['per_page'] + 1 }} to 
                                {{ min($pagination['current_page'] * $pagination['per_page'], $pagination['total']) }} of 
                                {{ $pagination['total'] }} entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    @if($pagination['current_page'] > 1)
                                        <li class="page-item">
                                            <a class="page-link" href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1]) }}">
                                                Previous
                                            </a>
                                        </li>
                                    @endif

                                    @for($i = 1; $i <= $pagination['last_page']; $i++)
                                        @if($i == 1 || $i == $pagination['last_page'] || ($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2))
                                            <li class="page-item {{ $i == $pagination['current_page'] ? 'active' : '' }}">
                                                <a class="page-link" href="{{ request()->fullUrlWithQuery(['page' => $i]) }}">
                                                    {{ $i }}
                                                </a>
                                            </li>
                                        @elseif($i == $pagination['current_page'] - 3 || $i == $pagination['current_page'] + 3)
                                            <li class="page-item disabled">
                                                <span class="page-link">...</span>
                                            </li>
                                        @endif
                                    @endfor

                                    @if($pagination['current_page'] < $pagination['last_page'])
                                        <li class="page-item">
                                            <a class="page-link" href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1]) }}">
                                                Next
                                            </a>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@php
function getPaymentMethodColor($code) {
    $colors = [
        'cash' => 'success',
        'bank_transfer' => 'primary',
        'ewallet' => 'info',
        'qris' => 'warning',
        'credit_card' => 'danger'
    ];
    return $colors[$code] ?? 'secondary';
}
@endphp

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            paging: false,
            searching: false,
            info: false,
            order: [[1, 'asc']] // Sort by name
        });
    });
</script>
@endsection