@extends('admin.layouts.main')

@section('title', 'Edit Payment Method')
@section('page-title', 'Edit Payment Method')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('admin.payment-methods.index') }}">Payment Methods</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.payment-methods.show', $paymentMethod['id']) }}">{{ $paymentMethod['name'] }}</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Edit Payment Method: {{ $paymentMethod['name'] }}</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.payment-methods.update', $paymentMethod['id']) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Basic Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="name">Payment Method Name *</label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                   id="name" name="name" value="{{ old('name', $paymentMethod['name']) }}" required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="code">Payment Type *</label>
                                            <select class="form-control @error('code') is-invalid @enderror" 
                                                    id="code" name="code" required>
                                                <option value="">Select Payment Type</option>
                                                <option value="cash" {{ old('code', $paymentMethod['code']) == 'cash' ? 'selected' : '' }}>Cash</option>
                                                <option value="bank_transfer" {{ old('code', $paymentMethod['code']) == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                                <option value="ewallet" {{ old('code', $paymentMethod['code']) == 'ewallet' ? 'selected' : '' }}>E-Wallet</option>
                                                <option value="qris" {{ old('code', $paymentMethod['code']) == 'qris' ? 'selected' : '' }}>QRIS</option>
                                                <option value="credit_card" {{ old('code', $paymentMethod['code']) == 'credit_card' ? 'selected' : '' }}>Credit Card</option>
                                            </select>
                                            @error('code')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_active" 
                                                       name="is_active" value="1" 
                                                       {{ old('is_active', $paymentMethod['is_active']) ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="is_active">Active</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <!-- Account Details -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Account Details</h6>
                                        <small class="text-muted">(For bank transfer, e-wallet, etc.)</small>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="account_number">Account Number</label>
                                            <input type="text" class="form-control @error('account_number') is-invalid @enderror" 
                                                   id="account_number" name="account_number" 
                                                   value="{{ old('account_number', $paymentMethod['account_number']) }}">
                                            @error('account_number')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="account_name">Account Name</label>
                                            <input type="text" class="form-control @error('account_name') is-invalid @enderror" 
                                                   id="account_name" name="account_name" 
                                                   value="{{ old('account_name', $paymentMethod['account_name']) }}">
                                            @error('account_name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Instructions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Payment Instructions</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <textarea class="form-control @error('instructions') is-invalid @enderror" 
                                                      id="instructions" name="instructions" rows="4">{{ old('instructions', $paymentMethod['instructions']) }}</textarea>
                                            @error('instructions')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.payment-methods.show', $paymentMethod['id']) }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left mr-1"></i> Cancel
                                    </a>
                                    <div>
                                        <a href="{{ route('admin.payment-methods.index') }}" class="btn btn-outline-secondary mr-2">
                                            Back to List
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save mr-1"></i> Update Payment Method
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const codeSelect = document.getElementById('code');
        const accountNumberInput = document.getElementById('account_number');
        const accountNameInput = document.getElementById('account_name');
        
        // Show/hide account details based on payment type
        function toggleAccountFields() {
            const type = codeSelect.value;
            
            if (type === 'cash') {
                accountNumberInput.disabled = true;
                accountNameInput.disabled = true;
            } else {
                accountNumberInput.disabled = false;
                accountNameInput.disabled = false;
            }
        }
        
        codeSelect.addEventListener('change', toggleAccountFields);
        
        // Initialize on page load
        toggleAccountFields();
    });
</script>
@endsection