@extends('admin.layouts.main')

@section('title', 'Add Payment Method')
@section('page-title', 'Add Payment Method')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('admin.payment-methods.index') }}">Payment Methods</a></li>
    <li class="breadcrumb-item active">Add Method</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Add New Payment Method</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.payment-methods.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Basic Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="name">Payment Method Name *</label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                   id="name" name="name" value="{{ old('name') }}" required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Display name for customers (e.g., "Bank Transfer - BCA", "GoPay", etc.)
                                            </small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="code">Payment Type *</label>
                                            <select class="form-control @error('code') is-invalid @enderror" 
                                                    id="code" name="code" required>
                                                <option value="">Select Payment Type</option>
                                                <option value="cash" {{ old('code') == 'cash' ? 'selected' : '' }}>Cash</option>
                                                <option value="bank_transfer" {{ old('code') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                                <option value="ewallet" {{ old('code') == 'ewallet' ? 'selected' : '' }}>E-Wallet</option>
                                                <option value="qris" {{ old('code') == 'qris' ? 'selected' : '' }}>QRIS</option>
                                                <option value="credit_card" {{ old('code') == 'credit_card' ? 'selected' : '' }}>Credit Card</option>
                                            </select>
                                            @error('code')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_active" 
                                                       name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="is_active">Active</label>
                                            </div>
                                            <small class="form-text text-muted">
                                                Inactive payment methods won't be available to customers
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <!-- Account Details -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Account Details</h6>
                                        <small class="text-muted">(For bank transfer, e-wallet, etc.)</small>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="account_number">Account Number</label>
                                            <input type="text" class="form-control @error('account_number') is-invalid @enderror" 
                                                   id="account_number" name="account_number" value="{{ old('account_number') }}">
                                            @error('account_number')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Bank account number, e-wallet number, or merchant ID
                                            </small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="account_name">Account Name</label>
                                            <input type="text" class="form-control @error('account_name') is-invalid @enderror" 
                                                   id="account_name" name="account_name" value="{{ old('account_name') }}">
                                            @error('account_name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Account holder name (e.g., "PT Chingu Bite", "John Doe")
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Instructions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Payment Instructions</h6>
                                        <small class="text-muted">Instructions for customers on how to use this payment method</small>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <textarea class="form-control @error('instructions') is-invalid @enderror" 
                                                      id="instructions" name="instructions" rows="4">{{ old('instructions') }}</textarea>
                                            @error('instructions')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Example for bank transfer: "Transfer to the account above and upload proof of payment. Use your order number as reference."
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.payment-methods.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left mr-1"></i> Back
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save mr-1"></i> Create Payment Method
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const codeSelect = document.getElementById('code');
        const accountNumberInput = document.getElementById('account_number');
        const accountNameInput = document.getElementById('account_name');
        const instructionsInput = document.getElementById('instructions');
        
        // Show/hide account details based on payment type
        function toggleAccountFields() {
            const type = codeSelect.value;
            
            if (type === 'cash') {
                accountNumberInput.disabled = true;
                accountNameInput.disabled = true;
                accountNumberInput.value = '';
                accountNameInput.value = '';
                
                // Set default instructions for cash
                if (!instructionsInput.value.trim()) {
                    instructionsInput.value = "Pay with cash upon order pickup or delivery.";
                }
            } else {
                accountNumberInput.disabled = false;
                accountNameInput.disabled = false;
                
                // Set default instructions if empty
                if (!instructionsInput.value.trim()) {
                    if (type === 'bank_transfer') {
                        instructionsInput.value = "Transfer to the account above and upload proof of payment. Use your order number as reference.";
                    } else if (type === 'ewallet') {
                        instructionsInput.value = "Send payment to the e-wallet number above and upload proof of payment.";
                    } else if (type === 'qris') {
                        instructionsInput.value = "Scan the QR code at checkout to complete your payment.";
                    } else if (type === 'credit_card') {
                        instructionsInput.value = "Enter your credit card details at checkout. Your payment will be processed securely.";
                    }
                }
            }
        }
        
        codeSelect.addEventListener('change', toggleAccountFields);
        
        // Initialize on page load
        toggleAccountFields();
    });
</script>
@endsection