@extends('admin.layouts.main')

@section('title', 'Menu Item Details')
@section('page-title', 'Menu Item Details')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{ route('admin.menu.index') }}">Menu Management</a></li>
    <li class="breadcrumb-item active">Details</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Item Information</h6>
                    <div>
                        <span class="badge badge-{{ $menu['is_available'] ? 'success' : 'danger' }}">
                            {{ $menu['is_available'] ? 'Available' : 'Unavailable' }}
                        </span>
                        @if($menu['is_best_seller'])
                            <span class="badge bg-warning">Best Seller</span>
                        @endif
                        @if($menu['is_special'])
                            <span class="badge bg-danger">Special</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center">
                            @if($menu['image_url'])
                                <img src="{{ $menu['image_url'] }}" alt="{{ $menu['name'] }}" 
                                     class="img-fluid rounded" style="max-height: 300px;">
                            @else
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                     style="height: 300px;">
                                    <i class="fas fa-utensils fa-4x text-muted"></i>
                                </div>
                            @endif
                        </div>
                        <div class="col-md-8">
                            <h4 class="font-weight-bold mb-3">{{ $menu['name'] }}</h4>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Category</label>
                                    <p class="font-weight-bold">{{ $menu['category_name'] ?? 'N/A' }}</p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Price</label>
                                    <p class="font-weight-bold">Rp {{ number_format($menu['price'], 0, ',', '.') }}</p>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Stock</label>
                                    <p class="font-weight-bold">
                                        @if($menu['stock'] === null)
                                            <span class="text-muted">Unlimited</span>
                                        @else
                                            <span class="{{ $menu['stock'] <= 10 ? 'text-danger' : 'text-success' }}">
                                                {{ $menu['stock'] }} units
                                            </span>
                                        @endif
                                    </p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Added On</label>
                                    <p class="font-weight-bold">
                                        {{ date('d M Y, H:i', strtotime($menu['created_at'])) }}
                                    </p>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="text-muted">Description</label>
                                <p class="font-weight-bold">{{ $menu['description'] ?? 'No description provided.' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sales Statistics -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Sales Statistics</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-primary">
                                    {{ $menu['total_sold'] ?? 0 }}
                                </div>
                                <div class="metric-label text-muted">Total Sold</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-success">
                                    Rp {{ number_format($menu['total_revenue'] ?? 0, 0, ',', '.') }}
                                </div>
                                <div class="metric-label text-muted">Total Revenue</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-info">
                                    {{ $menu['average_rating'] ?? 0 }}/5
                                </div>
                                <div class="metric-label text-muted">Average Rating</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Actions Card -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.menu.edit', $menu['id']) }}" class="btn btn-warning btn-block">
                            <i class="fas fa-edit mr-1"></i> Edit Item
                        </a>
                        
                        <form action="{{ route('admin.menu.toggle_availability', $menu['id']) }}" method="POST" class="d-grid">
                            @csrf
                            @method('PUT')
                            <button type="submit" class="btn btn-{{ $menu['is_available'] ? 'secondary' : 'success' }} btn-block">
                                <i class="fas fa-{{ $menu['is_available'] ? 'times' : 'check' }} mr-1"></i>
                                {{ $menu['is_available'] ? 'Make Unavailable' : 'Make Available' }}
                            </button>
                        </form>
                        
                        <form action="{{ route('admin.menu.destroy', $menu['id']) }}" method="POST" 
                              onsubmit="return confirm('Are you sure you want to delete this item?');" class="d-grid">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-block">
                                <i class="fas fa-trash mr-1"></i> Delete Item
                            </button>
                        </form>
                        
                        <a href="{{ route('admin.menu.index') }}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left mr-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Recent Reviews -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Recent Reviews</h6>
                </div>
                <div class="card-body">
                    @if(isset($menu['recent_reviews']) && count($menu['recent_reviews']) > 0)
                        @foreach($menu['recent_reviews'] as $review)
                        <div class="review-item mb-3 pb-3 border-bottom">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <strong>{{ $review['customer_name'] }}</strong>
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star {{ $i <= $review['rating'] ? 'text-warning' : 'text-secondary' }}" 
                                               style="font-size: 12px;"></i>
                                        @endfor
                                    </div>
                                </div>
                                <small class="text-muted">{{ date('d M Y', strtotime($review['created_at'])) }}</small>
                            </div>
                            <p class="mb-0">{{ $review['comment'] }}</p>
                        </div>
                        @endforeach
                    @else
                        <p class="text-muted text-center mb-0">No reviews yet</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .metric-box {
        transition: all 0.3s;
    }
    .metric-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .stars {
        color: #ffc107;
    }
    .stars .fa-star.text-secondary {
        color: #e0e0e0 !important;
    }
    .review-item:last-child {
        border-bottom: none !important;
        margin-bottom: 0 !important;
        padding-bottom: 0 !important;
    }
</style>
@endsection