{{-- resources/views/admin/menu/index.blade.php --}}
@extends('layouts.admin')

@section('title', 'Menu Management')
@section('page_title', 'Menu Management')
@section('icon', 'fa-utensils')

@section('breadcrumb')
    <li class="breadcrumb-item active">Menu Management</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-utensils me-2"></i>Menu Items
                        </h5>
                        <a href="{{ route('admin.menu.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New Item
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('admin.menu.index') }}" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="search" class="form-label">Search</label>
                                    <input type="text" class="form-control form-control-sm" 
                                           id="search" name="search" 
                                           value="{{ request('search') }}" 
                                           placeholder="Search by name...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="category_id" class="form-label">Category</label>
                                    <select class="form-control form-control-sm select2" 
                                            id="category_id" name="category_id">
                                        <option value="">All Categories</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category['id'] }}" 
                                                {{ request('category_id') == $category['id'] ? 'selected' : '' }}>
                                                {{ $category['name'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_available" class="form-label">Availability</label>
                                    <select class="form-control form-control-sm" 
                                            id="is_available" name="is_available">
                                        <option value="">All</option>
                                        <option value="1" {{ request('is_available') == '1' ? 'selected' : '' }}>
                                            Available
                                        </option>
                                        <option value="0" {{ request('is_available') == '0' ? 'selected' : '' }}>
                                            Unavailable
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <div class="d-flex gap-2 w-100">
                                    <button type="submit" class="btn btn-primary btn-sm flex-grow-1">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                    <a href="{{ route('admin.menu.index') }}" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-redo"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Menu Items Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Status</th>
                                    <th>Tags</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($menus as $index => $menu)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        @if($menu['image_url'])
                                            <img src="{{ $menu['image_url'] }}" 
                                                 alt="{{ $menu['name'] }}" 
                                                 class="rounded" 
                                                 style="width: 50px; height: 50px; object-fit: cover;">
                                        @else
                                            <div class="bg-light text-center rounded d-flex align-items-center justify-content-center" 
                                                 style="width: 50px; height: 50px;">
                                                <i class="fas fa-utensils text-muted"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>{{ $menu['name'] }}</strong>
                                        @if($menu['description'])
                                            <br>
                                            <small class="text-muted">{{ Str::limit($menu['description'], 50) }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $menu['category_name'] ?? 'N/A' }}</td>
                                    <td>
                                        <strong class="text-primary">
                                            Rp {{ number_format($menu['price'], 0, ',', '.') }}
                                        </strong>
                                    </td>
                                    <td>
                                        @if($menu['stock'] === null)
                                            <span class="text-muted">Unlimited</span>
                                        @else
                                            <span class="{{ $menu['stock'] <= 10 ? 'text-danger' : 'text-success' }}">
                                                {{ $menu['stock'] }}
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($menu['is_available'])
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i> Available
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-times-circle me-1"></i> Unavailable
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            @if($menu['is_best_seller'])
                                                <span class="badge bg-warning">Best Seller</span>
                                            @endif
                                            @if($menu['is_special'])
                                                <span class="badge bg-danger">Special</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('admin.menu.show', $menu['id']) }}" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.menu.edit', $menu['id']) }}" 
                                               class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger" 
                                                    onclick="confirmDelete('delete-menu-{{ $menu['id'] }}')"
                                                    data-bs-toggle="tooltip" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form action="{{ route('admin.menu.toggle_availability', $menu['id']) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" 
                                                        class="btn btn-{{ $menu['is_available'] ? 'secondary' : 'success' }}"
                                                        data-bs-toggle="tooltip" 
                                                        title="{{ $menu['is_available'] ? 'Make Unavailable' : 'Make Available' }}">
                                                    <i class="fas fa-{{ $menu['is_available'] ? 'times' : 'check' }}"></i>
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <form id="delete-menu-{{ $menu['id'] }}" 
                                              action="{{ route('admin.menu.destroy', $menu['id']) }}" 
                                              method="POST" style="display: none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-utensils fa-3x mb-3"></i>
                                            <h5>No menu items found</h5>
                                            <p>Try adjusting your search filters or add new items</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($pagination))
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing {{ $pagination['from'] ?? 0 }} to 
                                {{ $pagination['to'] ?? 0 }} of 
                                {{ $pagination['total'] ?? 0 }} entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    {{-- Previous Page Link --}}
                                    @if(isset($pagination['current_page']) && $pagination['current_page'] > 1)
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1]) }}">
                                                &laquo;
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link">&laquo;</span>
                                        </li>
                                    @endif

                                    {{-- Page Numbers --}}
                                    @if(isset($pagination['last_page']))
                                        @php
                                            $currentPage = $pagination['current_page'] ?? 1;
                                            $lastPage = $pagination['last_page'] ?? 1;
                                            $startPage = max(1, $currentPage - 2);
                                            $endPage = min($lastPage, $currentPage + 2);
                                        @endphp
                                        
                                        @for($i = $startPage; $i <= $endPage; $i++)
                                            @if($i == $currentPage)
                                                <li class="page-item active">
                                                    <span class="page-link">{{ $i }}</span>
                                                </li>
                                            @else
                                                <li class="page-item">
                                                    <a class="page-link" 
                                                       href="{{ request()->fullUrlWithQuery(['page' => $i]) }}">
                                                        {{ $i }}
                                                    </a>
                                                </li>
                                            @endif
                                        @endfor
                                    @endif

                                    {{-- Next Page Link --}}
                                    @if(isset($pagination['current_page']) && isset($pagination['last_page']) && 
                                        $pagination['current_page'] < $pagination['last_page'])
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1]) }}">
                                                &raquo;
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link">&raquo;</span>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[2, 'asc']],
            columnDefs: [
                { orderable: false, targets: [1, 8] } // Disable sorting for image and actions columns
            ]
        });
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Initialize Select2
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
    
    function confirmDelete(formId) {
        if (confirm('Are you sure you want to delete this item?')) {
            document.getElementById(formId).submit();
        }
    }
</script>
@endsection