{{-- resources/views/admin/menu/create.blade.php --}}
@extends('layouts.admin')

@section('title', 'Add Menu Item')
@section('page_title', 'Add Menu Item')
@section('icon', 'fa-plus-circle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.menu.index') }}">Menu Management</a></li>
    <li class="breadcrumb-item active">Add Item</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-plus-circle me-2"></i>Add New Menu Item
                        </h5>
                        <a href="{{ route('admin.menu.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left me-1"></i> Back to List
                        </a>
                    </div>
                </div>
                
                <form action="{{ route('admin.menu.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Basic Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="name" class="form-label">Name *</label>
                                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                       id="name" name="name" value="{{ old('name') }}" required>
                                                @error('name')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="category_id" class="form-label">Category *</label>
                                                <select class="form-control select2 @error('category_id') is-invalid @enderror" 
                                                        id="category_id" name="category_id" required>
                                                    <option value="">Select Category</option>
                                                    @foreach($categories as $category)
                                                        <option value="{{ $category['id'] }}" 
                                                            {{ old('category_id') == $category['id'] ? 'selected' : '' }}>
                                                            {{ $category['name'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('category_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="price" class="form-label">Price (Rp) *</label>
                                                <input type="number" class="form-control @error('price') is-invalid @enderror" 
                                                       id="price" name="price" value="{{ old('price') }}" 
                                                       min="0" step="100" required>
                                                @error('price')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="stock" class="form-label">Stock</label>
                                                <input type="number" class="form-control @error('stock') is-invalid @enderror" 
                                                       id="stock" name="stock" value="{{ old('stock') }}" 
                                                       min="0" placeholder="Leave empty for unlimited">
                                                @error('stock')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="description" class="form-label">Description</label>
                                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                                      id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                            @error('description')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <!-- Image Upload -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Image</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="image" class="form-label">Menu Image</label>
                                            <div class="input-group">
                                                <input type="file" class="form-control @error('image') is-invalid @enderror" 
                                                       id="image" name="image" accept="image/*">
                                                @error('image')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <small class="form-text text-muted">
                                                Recommended size: 500x500px. Max: 2MB. Formats: JPG, JPEG, PNG
                                            </small>
                                        </div>
                                        
                                        <div class="text-center">
                                            <img id="imagePreview" 
                                                 src="https://via.placeholder.com/300x300?text=No+Image" 
                                                 alt="Preview" 
                                                 class="img-fluid rounded border" 
                                                 style="max-height: 200px;">
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Settings -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Settings</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="is_available" name="is_available" 
                                                   value="1" {{ old('is_available', true) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_available">
                                                Available for Order
                                            </label>
                                        </div>
                                        
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="is_special" name="is_special" 
                                                   value="1" {{ old('is_special') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_special">
                                                Mark as Special
                                            </label>
                                        </div>
                                        
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="is_best_seller" name="is_best_seller" 
                                                   value="1" {{ old('is_best_seller') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_best_seller">
                                                Mark as Best Seller
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer">
                        <div class="d-flex justify-content-between">
                            <button type="reset" class="btn btn-secondary">
                                <i class="fas fa-redo me-1"></i> Reset
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Save Item
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Image preview
        const imageInput = document.getElementById('image');
        const imagePreview = document.getElementById('imagePreview');
        
        imageInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    imagePreview.src = e.target.result;
                };
                
                reader.readAsDataURL(this.files[0]);
            }
        });
        
        // Initialize Select2
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
</script>
@endsection