@extends('admin.layouts.app')

@section('title', 'Career Details')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Career Details</h1>
        <div class="btn-group">
            <a href="{{ route('admin.careers.edit', $apiData['data']['id']) }}" class="btn btn-warning">
                <i class="fas fa-edit me-1"></i> Edit
            </a>
            <a href="{{ route('admin.careers.index') }}" class="btn btn-secondary">
                <i class="fas fa-list me-1"></i> All Careers
            </a>
        </div>
    </div>

    @php $career = $apiData['data']; @endphp

    <div class="row">
        <!-- Main Information -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ $career['title'] }}</h5>
                    <div>
                        @if($career['is_urgent'])
                            <span class="badge bg-danger">Urgent</span>
                        @endif
                        @if($career['is_active'])
                            <span class="badge bg-success">Active</span>
                        @else
                            <span class="badge bg-secondary">Inactive</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <h6><i class="fas fa-building me-2"></i> Department</h6>
                            <p class="text-muted">{{ ucfirst($career['department']) }}</p>
                        </div>
                        <div class="col-md-4">
                            <h6><i class="fas fa-map-marker-alt me-2"></i> Location</h6>
                            <p class="text-muted">{{ $career['location'] }}</p>
                        </div>
                        <div class="col-md-4">
                            <h6><i class="fas fa-briefcase me-2"></i> Employment Type</h6>
                            <p class="text-muted">
                                <span class="badge bg-info">
                                    {{ str_replace('_', ' ', ucfirst($career['employment_type'])) }}
                                </span>
                            </p>
                        </div>
                    </div>

                    @if($career['salary_range'])
                    <div class="alert alert-info">
                        <h6><i class="fas fa-money-bill-wave me-2"></i> Salary Range</h6>
                        <p class="mb-0">{{ $career['salary_range'] }}</p>
                    </div>
                    @endif

                    <div class="mb-4">
                        <h5 class="mb-3">Job Description</h5>
                        <div class="border rounded p-3 bg-light">
                            {!! nl2br(e($career['description'])) !!}
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-3">Requirements</h5>
                        <div class="border rounded p-3 bg-light">
                            {!! nl2br(e($career['requirements'])) !!}
                        </div>
                    </div>

                    @if($career['benefits'])
                    <div class="mb-4">
                        <h5 class="mb-3">Benefits</h5>
                        <div class="border rounded p-3 bg-light">
                            {!! nl2br(e($career['benefits'])) !!}
                        </div>
                    </div>
                    @endif
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-calendar-plus me-1"></i>
                                Created: {{ \Carbon\Carbon::parse($career['created_at'])->format('M d, Y') }}
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            <small class="text-muted">
                                <i class="fas fa-eye me-1"></i>
                                Views: {{ $career['views_count'] ?? 0 }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Application Info -->
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0">Application Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6>Application Deadline</h6>
                        <div class="alert {{ \Carbon\Carbon::parse($career['application_deadline'])->isPast() ? 'alert-danger' : 'alert-success' }}">
                            <i class="fas fa-calendar-alt me-2"></i>
                            {{ \Carbon\Carbon::parse($career['application_deadline'])->format('F d, Y') }}
                            @if(\Carbon\Carbon::parse($career['application_deadline'])->isPast())
                                <span class="badge bg-danger">Expired</span>
                            @else
                                <span class="badge bg-success">Active</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <h6>Applications Received</h6>
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="progress" style="height: 20px;">
                                    <div class="progress-bar bg-success" style="width: {{ min(($career['applications_count'] ?? 0) * 10, 100) }}%">
                                        {{ $career['applications_count'] ?? 0 }} applications
                                    </div>
                                </div>
                            </div>
                            <div class="ms-3">
                                <a href="{{ route('admin.career-applications.index') }}" 
                                   class="btn btn-sm btn-outline-info">
                                    View All
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.career-applications.index', ['career_id' => $career['id']]) }}" 
                           class="btn btn-primary">
                            <i class="fas fa-users me-1"></i> View Applications
                        </a>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.careers.edit', $career['id']) }}" class="btn btn-warning">
                            <i class="fas fa-edit me-1"></i> Edit Career
                        </a>
                        
                        <form action="{{ route('admin.careers.destroy', $career['id']) }}" method="POST" class="d-grid">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" 
                                    onclick="return confirm('Delete this career listing? This action cannot be undone.')">
                                <i class="fas fa-trash me-1"></i> Delete Career
                            </button>
                        </form>

                        <a href="javascript:void(0)" class="btn btn-outline-primary" 
                           onclick="copyToClipboard('{{ route('careers.public.show', $career['id']) }}')">
                            <i class="fas fa-link me-1"></i> Copy Public Link
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            alert('Link copied to clipboard!');
        }, function(err) {
            console.error('Could not copy text: ', err);
        });
    }
</script>
@endpush
@endsection