@extends('admin.layouts.app')

@section('title', 'Edit Career')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Career</h1>
        <div class="btn-group">
            <a href="{{ route('admin.careers.show', $career['id']) }}" class="btn btn-info">
                <i class="fas fa-eye me-1"></i> View
            </a>
            <a href="{{ route('admin.careers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to List
            </a>
        </div>
    </div>

    <div class="card shadow">
        <div class="card-body">
            <form method="POST" action="{{ route('admin.careers.update', $career['id']) }}">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="title" class="form-label">Job Title *</label>
                            <input type="text" class="form-control" id="title" name="title" 
                                   value="{{ old('title', $career['title']) }}" required>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="department" class="form-label">Department *</label>
                                <input type="text" class="form-control" id="department" name="department" 
                                       value="{{ old('department', $career['department']) }}" required>
                            </div>
                            <div class="col-md-6">
                                <label for="location" class="form-label">Location *</label>
                                <input type="text" class="form-control" id="location" name="location" 
                                       value="{{ old('location', $career['location']) }}" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="employment_type" class="form-label">Employment Type *</label>
                            <select class="form-control" id="employment_type" name="employment_type" required>
                                <option value="">Select Type</option>
                                @foreach($employmentTypes as $type)
                                    <option value="{{ $type }}" 
                                        {{ old('employment_type', $career['employment_type']) == $type ? 'selected' : '' }}>
                                        {{ str_replace('_', ' ', ucfirst($type)) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Job Description *</label>
                            <textarea class="form-control" id="description" name="description" 
                                      rows="5" required>{{ old('description', $career['description']) }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label for="requirements" class="form-label">Requirements *</label>
                            <textarea class="form-control" id="requirements" name="requirements" 
                                      rows="5" required>{{ old('requirements', $career['requirements']) }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label for="benefits" class="form-label">Benefits</label>
                            <textarea class="form-control" id="benefits" name="benefits" 
                                      rows="3">{{ old('benefits', $career['benefits']) }}</textarea>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Additional Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="salary_range" class="form-label">Salary Range</label>
                                    <input type="text" class="form-control" id="salary_range" name="salary_range" 
                                           value="{{ old('salary_range', $career['salary_range']) }}">
                                </div>

                                <div class="mb-3">
                                    <label for="application_deadline" class="form-label">Application Deadline *</label>
                                    <input type="date" class="form-control" id="application_deadline" 
                                           name="application_deadline" 
                                           value="{{ old('application_deadline', $career['application_deadline']) }}" 
                                           required>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_active" 
                                               name="is_active" value="1" 
                                               {{ old('is_active', $career['is_active']) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">Active Listing</label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_urgent" 
                                               name="is_urgent" value="1" 
                                               {{ old('is_urgent', $career['is_urgent']) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_urgent">Mark as Urgent</label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="views_count" class="form-label">Views Count</label>
                                    <input type="number" class="form-control" id="views_count" name="views_count" 
                                           value="{{ old('views_count', $career['views_count'] ?? 0) }}" min="0">
                                </div>
                            </div>
                        </div>

                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Statistics</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-2">
                                    <small class="text-muted">Created:</small>
                                    <p class="mb-0">
                                        {{ \Carbon\Carbon::parse($career['created_at'])->format('M d, Y') }}
                                    </p>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">Last Updated:</small>
                                    <p class="mb-0">
                                        {{ \Carbon\Carbon::parse($career['updated_at'])->format('M d, Y') }}
                                    </p>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">Applications:</small>
                                    <p class="mb-0">{{ $career['applications_count'] ?? 0 }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Update Career
                            </button>
                            <button type="reset" class="btn btn-secondary">
                                <i class="fas fa-redo me-1"></i> Reset Changes
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection