@extends('admin.layouts.app')

@section('title', 'Application Details')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Application Details</h1>
        <div class="btn-group">
            <a href="{{ route('admin.career-applications.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to List
            </a>
        </div>
    </div>

    @php $application = $apiData['data']; @endphp

    <div class="row">
        <!-- Applicant Info -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Applicant Information</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6>Full Name</h6>
                            <p class="text-muted">{{ $application['applicant_name'] }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Applied Position</h6>
                            <p class="text-muted">
                                {{ $application['career']['title'] ?? 'N/A' }}
                                @if($application['career']['department'] ?? false)
                                    <br><small class="text-muted">{{ $application['career']['department'] }}</small>
                                @endif
                            </p>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6>Contact Information</h6>
                            <p class="mb-1">
                                <i class="fas fa-envelope me-2"></i>{{ $application['applicant_email'] }}
                            </p>
                            <p class="mb-0">
                                <i class="fas fa-phone me-2"></i>{{ $application['applicant_phone'] }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h6>Application Timeline</h6>
                            <p class="mb-1">
                                <i class="fas fa-calendar-plus me-2"></i>
                                Submitted: {{ \Carbon\Carbon::parse($application['submitted_at'])->format('M d, Y H:i') }}
                            </p>
                            @if($application['updated_at'] != $application['created_at'])
                                <p class="mb-0">
                                    <i class="fas fa-calendar-check me-2"></i>
                                    Last Updated: {{ \Carbon\Carbon::parse($application['updated_at'])->format('M d, Y H:i') }}
                                </p>
                            @endif
                        </div>
                    </div>

                    @if($application['cover_letter'])
                    <div class="mb-4">
                        <h5>Cover Letter</h5>
                        <div class="border rounded p-3 bg-light">
                            {!! nl2br(e($application['cover_letter'])) !!}
                        </div>
                    </div>
                    @endif

                    <!-- Status Update -->
                    <div class="mb-4">
                        <h5>Update Status</h5>
                        <form method="POST" action="{{ route('admin.career-applications.status.update', $application['id']) }}">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-md-6">
                                    <select name="status" class="form-control mb-2" required>
                                        @foreach($statuses as $status)
                                            <option value="{{ $status }}" 
                                                {{ $application['status'] == $status ? 'selected' : '' }}>
                                                {{ ucfirst($status) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="fas fa-save me-1"></i> Update Status
                                    </button>
                                </div>
                            </div>
                            <div class="mt-2">
                                <textarea name="notes" class="form-control" rows="2" 
                                          placeholder="Internal notes (optional)">{{ $application['notes'] ?? '' }}</textarea>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Status Card -->
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0">Application Status</h6>
                </div>
                <div class="card-body">
                    @php
                        $statusColors = [
                            'pending' => 'warning',
                            'reviewed' => 'info',
                            'interviewed' => 'primary',
                            'accepted' => 'success',
                            'rejected' => 'danger'
                        ];
                    @endphp
                    
                    <div class="text-center mb-3">
                        <span class="badge bg-{{ $statusColors[$application['status']] ?? 'secondary' }} p-3" 
                              style="font-size: 1.1rem">
                            {{ ucfirst($application['status']) }}
                        </span>
                    </div>

                    <div class="timeline">
                        @php
                            $steps = [
                                'pending' => 'Application Submitted',
                                'reviewed' => 'Under Review',
                                'interviewed' => 'Interview Scheduled',
                                'accepted' => 'Accepted',
                                'rejected' => 'Rejected'
                            ];
                            
                            $currentStep = array_search($application['status'], array_keys($steps));
                        @endphp
                        
                        @foreach($steps as $status => $label)
                            <div class="timeline-step {{ $loop->index <= $currentStep ? 'completed' : '' }}">
                                <div class="timeline-content">
                                    <div class="timeline-icon">
                                        @if($loop->index < $currentStep)
                                            <i class="fas fa-check-circle text-success"></i>
                                        @elseif($loop->index == $currentStep)
                                            <i class="fas fa-circle text-primary"></i>
                                        @else
                                            <i class="fas fa-circle text-muted"></i>
                                        @endif
                                    </div>
                                    <div class="timeline-label">{{ $label }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Documents Card -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Documents</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($application['applicant_cv'])
                        <a href="{{ $application['applicant_cv'] }}" 
                           target="_blank" class="btn btn-success">
                            <i class="fas fa-file-pdf me-2"></i> View CV/Resume
                        </a>
                        @endif
                        
                        <button type="button" class="btn btn-outline-primary" 
                                onclick="copyToClipboard('{{ $application['applicant_email'] }}')">
                            <i class="fas fa-copy me-2"></i> Copy Email
                        </button>
                        
                        <a href="mailto:{{ $application['applicant_email'] }}" 
                           class="btn btn-outline-info">
                            <i class="fas fa-envelope me-2"></i> Send Email
                        </a>
                    </div>
                </div>
            </div>

            <!-- Notes Card -->
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0">Internal Notes</h6>
                </div>
                <div class="card-body">
                    @if($application['notes'])
                        <div class="border rounded p-3 bg-light mb-3">
                            {!! nl2br(e($application['notes'])) !!}
                        </div>
                    @else
                        <p class="text-muted mb-3">No notes added yet.</p>
                    @endif
                    
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        These notes are only visible to administrators.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    
    .timeline-step {
        margin-bottom: 15px;
        position: relative;
    }
    
    .timeline-step.completed .timeline-label {
        color: #28a745;
        font-weight: 500;
    }
    
    .timeline-icon {
        position: absolute;
        left: -30px;
        top: 0;
        width: 24px;
        height: 24px;
        text-align: center;
    }
    
    .timeline-label {
        margin-left: 10px;
    }
</style>
@endpush

@push('scripts')
<script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            alert('Copied to clipboard!');
        }, function(err) {
            console.error('Could not copy text: ', err);
        });
    }
</script>
@endpush
@endsection