@extends('admin.layouts.app')

@section('title', 'Career Applications')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Career Applications</h1>
        <div class="dropdown">
            <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                <i class="fas fa-download me-1"></i> Export
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#"><i class="fas fa-file-excel me-2"></i> Excel</a></li>
                <li><a class="dropdown-item" href="#"><i class="fas fa-file-pdf me-2"></i> PDF</a></li>
            </ul>
        </div>
    </div>

    <!-- Filters -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.career-applications.index') }}">
                <div class="row">
                    <div class="col-md-3 mb-2">
                        <input type="text" name="search" class="form-control" placeholder="Search applicant..." 
                               value="{{ request('search') }}">
                    </div>
                    <div class="col-md-3 mb-2">
                        <select name="status" class="form-control">
                            <option value="">All Status</option>
                            @foreach($statuses as $status)
                                <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <select name="career_id" class="form-control">
                            <option value="">All Careers</option>
                            <!-- You would populate this from API -->
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i> Filter
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Applications Table -->
    <div class="card shadow">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Applicant</th>
                            <th>Position</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Applied Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($apiData['data'] ?? []) as $application)
                        <tr>
                            <td>
                                <strong>{{ $application['applicant_name'] }}</strong>
                            </td>
                            <td>
                                <small>{{ $application['career']['title'] ?? 'N/A' }}</small>
                            </td>
                            <td>{{ $application['applicant_email'] }}</td>
                            <td>{{ $application['applicant_phone'] }}</td>
                            <td>{{ \Carbon\Carbon::parse($application['submitted_at'])->format('M d, Y') }}</td>
                            <td>
                                @php
                                    $statusColors = [
                                        'pending' => 'warning',
                                        'reviewed' => 'info',
                                        'interviewed' => 'primary',
                                        'accepted' => 'success',
                                        'rejected' => 'danger'
                                    ];
                                @endphp
                                <span class="badge bg-{{ $statusColors[$application['status']] ?? 'secondary' }}">
                                    {{ ucfirst($application['status']) }}
                                </span>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.career-applications.show', $application['id']) }}" 
                                       class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-warning" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#statusModal{{ $application['id'] }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="{{ $application['applicant_cv'] }}" 
                                       target="_blank" class="btn btn-sm btn-success">
                                        <i class="fas fa-file-download"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No applications found</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if(isset($apiData['meta']) && $apiData['meta']['last_page'] > 1)
                <nav class="mt-4">
                    <ul class="pagination justify-content-center">
                        <li class="page-item {{ $apiData['meta']['current_page'] == 1 ? 'disabled' : '' }}">
                            <a class="page-link" 
                               href="{{ request()->fullUrlWithQuery(['page' => $apiData['meta']['current_page'] - 1]) }}">
                                Previous
                            </a>
                        </li>
                        
                        @for($i = 1; $i <= $apiData['meta']['last_page']; $i++)
                            <li class="page-item {{ $apiData['meta']['current_page'] == $i ? 'active' : '' }}">
                                <a class="page-link" 
                                   href="{{ request()->fullUrlWithQuery(['page' => $i]) }}">
                                    {{ $i }}
                                </a>
                            </li>
                        @endfor
                        
                        <li class="page-item {{ $apiData['meta']['current_page'] == $apiData['meta']['last_page'] ? 'disabled' : '' }}">
                            <a class="page-link" 
                               href="{{ request()->fullUrlWithQuery(['page' => $apiData['meta']['current_page'] + 1]) }}">
                                Next
                            </a>
                        </li>
                    </ul>
                </nav>
            @endif
        </div>
    </div>
</div>

<!-- Status Modals -->
@foreach(($apiData['data'] ?? []) as $application)
<div class="modal fade" id="statusModal{{ $application['id'] }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" 
                  action="{{ route('admin.career-applications.status.update', $application['id']) }}">
                @csrf
                @method('PUT')
                
                <div class="modal-header">
                    <h5 class="modal-title">Update Application Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="status{{ $application['id'] }}" class="form-label">Status</label>
                        <select class="form-control" id="status{{ $application['id'] }}" name="status" required>
                            @foreach($statuses as $status)
                                <option value="{{ $status }}" 
                                    {{ $application['status'] == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="notes{{ $application['id'] }}" class="form-label">Notes</label>
                        <textarea class="form-control" id="notes{{ $application['id'] }}" 
                                  name="notes" rows="3">{{ $application['notes'] ?? '' }}</textarea>
                        <small class="text-muted">Internal notes (not visible to applicant)</small>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Status</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
@endsection