# Script to refactor Web Controllers - remove BaseApiController dependency
# This script will be run to replace API calls with direct database access

$controllers = @(
    "app\Http\Controllers\Web\Customer\OrderController.php",
    "app\Http\Controllers\Web\Customer\PaymentController.php",
    "app\Http\Controllers\Web\Customer\ReviewController.php",
    "app\Http\Controllers\Web\Customer\CareerController.php",
    "app\Http\Controllers\Web\Employee\OrderManagementController.php",
    "app\Http\Controllers\Web\Employee\PaymentConfirmationController.php",
    "app\Http\Controllers\Web\Employee\ReceiptController.php",
    "app\Http\Controllers\Web\Admin\MenuManagementController.php",
    "app\Http\Controllers\Web\Admin\PromoManagementController.php",
    "app\Http\Controllers\Web\Admin\PaymentMethodController.php",
    "app\Http\Controllers\Web\Admin\CareerManagementController.php",
    "app\Http\Controllers\Web\Admin\SystemSettingController.php",
    "app\Http\Controllers\Web\Admin\ReportController.php"
)

foreach ($controller in $controllers) {
    $fullPath = "d:\chingu\Chingu-Bite-fix (3)\Chingu-Bite-fix\$controller"
    if (Test-Path $fullPath) {
        Write-Host "Processing: $controller" -ForegroundColor Yellow
        
        # Read content
        $content = Get-Content $fullPath -Raw
        
        # Replace BaseApiController with Controller
        $content = $content -replace 'use App\\Http\\Controllers\\Web\\Api\\BaseApiController;', 'use App\Http\Controllers\Controller;'
        $content = $content -replace 'extends BaseApiController', 'extends Controller'
        
        # Save to backup
        $backupPath = $fullPath -replace '\.php$', '_backup.php'
        Copy-Item $fullPath $backupPath -Force
        
        Write-Host "  ✓ Backed up to: $backupPath" -ForegroundColor Green
    }
}

Write-Host "`nRefactoring preparation completed!" -ForegroundColor Cyan
Write-Host "Next step: Manually refactor each controller to use Models directly" -ForegroundColor Cyan
