<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    public function run(): void
    {
        
        // 1. Create fixed admin account (MUST BE UNIQUE)
        User::create([
            'name' => 'Super Admin',
            'email' => 'admin@chingubite.com', 
            'phone' => '081234567890',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'email_verified_at' => now(),
        ]);
        
        $this->command->info('✅ Created Super Admin: admin@chingubite.com');
        
        // 2. Create fixed employee accounts (UNIQUE EMAILS)
        $employees = [
            ['name' => 'Manager Kim', 'email' => 'manager@chingubite.com', 'phone' => '081234567891'],
            ['name' => 'Chef Lee', 'email' => 'chef@chingubite.com', 'phone' => '081234567892'],
            ['name' => 'Server Park', 'email' => 'server@chingubite.com', 'phone' => '081234567893'],
            ['name' => 'Cashier Choi', 'email' => 'cashier@chingubite.com', 'phone' => '081234567894'],
            ['name' => 'Waiter Jung', 'email' => 'waiter@chingubite.com', 'phone' => '081234567895'],
        ];
        
        foreach ($employees as $employee) {
            User::create([
                ...$employee,
                'password' => Hash::make('employee123'),
                'role' => 'employee',
                'email_verified_at' => now(),
            ]);
            $this->command->info("✅ Created Employee: {$employee['email']}");
        }
        
        // 3. Create fixed customer accounts (UNIQUE EMAILS)
        $customers = [
            ['name' => 'Regular Customer', 'email' => 'customer@chingubite.com', 'phone' => '081234567896'],
            ['name' => 'VIP Customer', 'email' => 'vip@chingubite.com', 'phone' => '081234567897'],
            ['name' => 'New Customer', 'email' => 'newcustomer@chingubite.com', 'phone' => '081234567898'],
        ];
        
        foreach ($customers as $customer) {
            User::create([
                ...$customer,
                'password' => Hash::make('customer123'),
                'role' => 'customer',
                'email_verified_at' => now(),
            ]);
            $this->command->info("✅ Created Customer: {$customer['email']}");
        }
        
        // 4. Create additional random users USING FACTORY (will auto-generate unique emails)
        $this->command->info('Creating random customers...');
        User::factory()->count(15)->customer()->create();
        
        $this->command->info('Creating random employees...');
        User::factory()->count(3)->employee()->create();
        
        $this->command->info('Creating random admin...');
        User::factory()->count(1)->admin()->create();
        
        $totalUsers = User::count();
        $adminCount = User::where('role', 'admin')->count();
        $employeeCount = User::where('role', 'employee')->count();
        $customerCount = User::where('role', 'customer')->count();
        
        $this->command->info("\nUsers seeded successfully!");
        $this->command->info("Total Users: {$totalUsers}");
        $this->command->info("Admins: {$adminCount}");
        $this->command->info("Employees: {$employeeCount}");
        $this->command->info("Customers: {$customerCount}");
        
        // Show login credentials
        $this->command->info("\nLOGIN CREDENTIALS:");
        $this->command->info("   Admin: admin@chingubite.com / admin123");
        $this->command->info("   Employee: manager@chingubite.com / employee123");
        $this->command->info("   Customer: customer@chingubite.com / customer123");
    }
}