<?php

namespace Database\Seeders;

use App\Models\JobPosting;
use App\Models\Category;
use App\Models\Menu;
use App\Models\PaymentMethod;
use App\Models\Promo;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TestDataSeeder extends Seeder
{
    public function run(): void
    {
        // Truncate tables
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        JobPosting::truncate();
        Category::truncate();
        Menu::truncate();
        PaymentMethod::truncate();
        Promo::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1');

        // Job Postings
        $jobs = [
            [
                'title' => 'Kitchen Staff',
                'department' => 'Kitchen',
                'location' => 'Jakarta Selatan',
                'description' => 'Bertanggung jawab dalam persiapan bahan makanan dan membantu chef utama.',
                'requirements' => 'Pengalaman minimal 1 tahun di dapur restoran, mampu bekerja tim, sehat jasmani',
                'benefits' => 'BPJS, makan siang, bonus kinerja',
                'employment_type' => 'full_time',
                'salary_range' => '3.5 - 4.5 Juta',
                'application_deadline' => now()->addDays(30),
                'is_active' => true,
                'views_count' => 0,
            ],
            [
                'title' => 'Wait Staff / Pelayan',
                'department' => 'Front House',
                'location' => 'Jakarta Selatan',
                'description' => 'Melayani pelanggan, mengambil order, dan menjaga kebersihan area makan.',
                'requirements' => 'Ramah, komunikasi baik, pengalaman di F&B lebih diutamakan',
                'benefits' => 'BPJS, tip, seragam, training',
                'employment_type' => 'part_time',
                'salary_range' => '2.5 - 3 Juta',
                'application_deadline' => now()->addDays(21),
                'is_active' => true,
                'views_count' => 0,
            ],
            [
                'title' => 'Cashier',
                'department' => 'Finance',
                'location' => 'Jakarta Selatan',
                'description' => 'Menangani transaksi pembayaran dan administrasi kas.',
                'requirements' => 'Jujur, teliti, mampu mengoperasikan komputer, pengalaman sebagai kasir',
                'benefits' => 'BPJS, asuransi kesehatan, bonus',
                'employment_type' => 'full_time',
                'salary_range' => '3 - 4 Juta',
                'application_deadline' => now()->addDays(15),
                'is_active' => true,
                'views_count' => 0,
            ],
        ];

        foreach ($jobs as $job) {
            JobPosting::create($job);
        }

        // Categories
        $categories = [
            ['name' => 'Makanan Utama', 'description' => 'Menu utama Korea', 'is_active' => true],
            ['name' => 'Minuman', 'description' => 'Minuman khas Korea', 'is_active' => true],
            ['name' => 'Snack', 'description' => 'Camilan Korea', 'is_active' => true],
        ];

        foreach ($categories as $cat) {
            Category::create($cat);
        }

        // Menus
        $menus = [
            [
                'category_id' => 1,
                'name' => 'Kimchi Fried Rice',
                'description' => 'Nasi goreng dengan kimchi asli Korea',
                'price' => 35000,
                'stock' => 20,
                'is_available' => true,
                'is_best_seller' => true,
            ],
            [
                'category_id' => 1,
                'name' => 'Bibimbap',
                'description' => 'Nasi campur Korea dengan sayuran dan daging',
                'price' => 45000,
                'stock' => 15,
                'is_available' => true,
                'is_special' => true,
            ],
            [
                'category_id' => 2,
                'name' => 'Korean Milk Tea',
                'description' => 'Teh susu ala Korea',
                'price' => 25000,
                'stock' => 30,
                'is_available' => true,
            ],
        ];

        foreach ($menus as $menu) {
            Menu::create($menu);
        }

        // Payment Methods
        $paymentMethods = [
            ['name' => 'Tunai', 'code' => 'cash', 'is_active' => true],
            ['name' => 'Transfer Bank BCA', 'code' => 'bank_transfer', 'account_number' => '1234567890', 'account_name' => 'Chingu Bite', 'is_active' => true],
            ['name' => 'QRIS', 'code' => 'qris', 'is_active' => true],
            ['name' => 'GoPay', 'code' => 'ewallet', 'is_active' => true],
        ];

        foreach ($paymentMethods as $method) {
            PaymentMethod::create($method);
        }

        // Promo
        Promo::create([
            'name' => 'Grand Opening',
            'description' => 'Diskon 20% untuk semua menu',
            'type' => 'percentage',
            'discount_value' => 20,
            'start_date' => now(),
            'end_date' => now()->addMonth(),
            'is_active' => true,
        ]);
    }
}