<?php
// database/seeders/SystemSettingsSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SystemSettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            // General Settings
            ['key' => 'app_name', 'value' => 'Chingu Bite', 'type' => 'string', 'group' => 'general', 'description' => 'Nama aplikasi', 'is_public' => true],
            ['key' => 'app_logo', 'value' => '/logo.png', 'type' => 'string', 'group' => 'general', 'description' => 'Logo aplikasi', 'is_public' => true],
            ['key' => 'app_description', 'value' => 'Restaurant Makanan Korea', 'type' => 'string', 'group' => 'general', 'description' => 'Deskripsi aplikasi', 'is_public' => true],
            
            // Tax & Fee Settings
            ['key' => 'tax_rate', 'value' => '11', 'type' => 'number', 'group' => 'tax', 'description' => 'Persentase pajak (%)', 'is_public' => false],
            ['key' => 'service_fee', 'value' => '5000', 'type' => 'number', 'group' => 'tax', 'description' => 'Biaya layanan (Rp)', 'is_public' => false],
            ['key' => 'tax_inclusive', 'value' => 'false', 'type' => 'boolean', 'group' => 'tax', 'description' => 'Pajak termasuk di harga?', 'is_public' => false],
            
            // Operational Settings
            ['key' => 'timezone', 'value' => 'Asia/Jakarta', 'type' => 'string', 'group' => 'operational', 'description' => 'Zona waktu', 'is_public' => false],
            ['key' => 'currency', 'value' => 'IDR', 'type' => 'string', 'group' => 'operational', 'description' => 'Mata uang', 'is_public' => true],
            ['key' => 'currency_symbol', 'value' => 'Rp', 'type' => 'string', 'group' => 'operational', 'description' => 'Simbol mata uang', 'is_public' => true],
            ['key' => 'minimum_order', 'value' => '25000', 'type' => 'number', 'group' => 'operational', 'description' => 'Minimum order (Rp)', 'is_public' => true],
            
            // Notification Settings
            ['key' => 'notification_order_new', 'value' => 'true', 'type' => 'boolean', 'group' => 'notification', 'description' => 'Notifikasi pesanan baru', 'is_public' => false],
            ['key' => 'notification_payment_confirmed', 'value' => 'true', 'type' => 'boolean', 'group' => 'notification', 'description' => 'Notifikasi pembayaran dikonfirmasi', 'is_public' => false],
            ['key' => 'email_sender', 'value' => 'noreply@chingubite.com', 'type' => 'string', 'group' => 'notification', 'description' => 'Email pengirim', 'is_public' => false],
            
            // Payment Settings
            ['key' => 'payment_confirmation_timeout', 'value' => '24', 'type' => 'number', 'group' => 'payment', 'description' => 'Timeout konfirmasi pembayaran (jam)', 'is_public' => false],
            ['key' => 'auto_confirm_cash_payment', 'value' => 'true', 'type' => 'boolean', 'group' => 'payment', 'description' => 'Auto konfirmasi pembayaran tunai', 'is_public' => false],
            ['key' => 'max_payment_attempts', 'value' => '3', 'type' => 'number', 'group' => 'payment', 'description' => 'Maksimal percobaan pembayaran', 'is_public' => false],
            
            // Restaurant Settings
            ['key' => 'restaurant_address', 'value' => 'Jl. Korea No. 123, Jakarta', 'type' => 'string', 'group' => 'general', 'description' => 'Alamat restoran', 'is_public' => true],
            ['key' => 'restaurant_phone', 'value' => '(021) 12345678', 'type' => 'string', 'group' => 'general', 'description' => 'Telepon restoran', 'is_public' => true],
            ['key' => 'restaurant_email', 'value' => 'info@chingubite.com', 'type' => 'string', 'group' => 'general', 'description' => 'Email restoran', 'is_public' => true],
        ];
        
        foreach ($settings as $setting) {
            DB::table('system_settings')->insert([
                ...$setting,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        
        $this->command->info('✅ System settings seeded!');
    }
}