<?php
// database/seeders/PromosSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Promo;

class PromosSeeder extends Seeder
{
    public function run(): void
    {
        // Create fixed promos
        $fixedPromos = [
            [
                'name' => 'Grand Opening',
                'type' => 'percentage',
                'discount_value' => 20,
                'code' => 'OPEN20',
                'start_date' => now()->subDays(30),
                'end_date' => now()->addDays(30),
                'is_active' => true,
            ],
            [
                'name' => 'Weekend Special',
                'type' => 'fixed',
                'discount_value' => 15000,
                'code' => 'WEEKEND15',
                'start_date' => now()->startOfWeek(),
                'end_date' => now()->endOfWeek(),
                'is_active' => true,
            ],
            [
                'name' => 'Buy 1 Get 1',
                'type' => 'bogo',
                'discount_value' => 0,
                'code' => 'BOGO',
                'start_date' => now()->subDays(15),
                'end_date' => now()->addDays(15),
                'is_active' => true,
            ],
        ];
        
        foreach ($fixedPromos as $promo) {
            Promo::create([
                ...$promo,
                'description' => 'Special promotion for our customers',
                'min_purchase' => 50000,
                'max_discount' => 50000,
            ]);
        }
        
        // Create random promos
        Promo::factory()->count(10)->create();
        
        // Create some expired promos
        Promo::factory()->count(3)->expired()->create();
        
        $this->command->info('✅ Promos seeded! Total: ' . Promo::count());
    }
}