<?php
// database/seeders/PaymentMethodsSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PaymentMethodsSeeder extends Seeder
{
    public function run(): void
    {
        $methods = [
            [
                'name' => 'Cash',
                'code' => 'cash',
                'account_number' => null,
                'account_name' => null,
                'is_active' => true,
            ],
            [
                'name' => 'Bank Transfer BCA',
                'code' => 'bank_transfer',
                'account_number' => '1234567890',
                'account_name' => 'Chingu Bite Restaurant',
                'is_active' => true,
            ],
            [
                'name' => 'Bank Transfer Mandiri',
                'code' => 'bank_transfer',
                'account_number' => '0987654321',
                'account_name' => 'Chingu Bite Restaurant',
                'is_active' => true,
            ],
            [
                'name' => 'OVO',
                'code' => 'ewallet',
                'account_number' => '081234567890',
                'account_name' => 'Chingu Bite',
                'is_active' => true,
            ],
            [
                'name' => 'GoPay',
                'code' => 'ewallet',
                'account_number' => '081234567891',
                'account_name' => 'Chingu Bite',
                'is_active' => true,
            ],
            [
                'name' => 'DANA',
                'code' => 'ewallet',
                'account_number' => '081234567892',
                'account_name' => 'Chingu Bite',
                'is_active' => true,
            ],
            [
                'name' => 'QRIS',
                'code' => 'qris',
                'account_number' => null,
                'account_name' => null,
                'is_active' => true,
            ],
            [
                'name' => 'Credit Card',
                'code' => 'credit_card',
                'account_number' => null,
                'account_name' => null,
                'is_active' => true,
            ],
        ];
        
        foreach ($methods as $method) {
            DB::table('payment_methods')->insert([
                ...$method,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        
        $this->command->info('✅ Payment methods seeded!');
    }
}