<?php
// database/seeders/OrderItemsSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\OrderItem;
use App\Models\Order;
use App\Models\Menu;

class OrderItemsSeeder extends Seeder
{
    public function run(): void
    {
        // This seeder is already handled in OrdersSeeder
        // We'll just create some additional random order items
        
        $orders = Order::doesntHave('orderItems')->get();
        
        foreach ($orders as $order) {
            $menuCount = rand(1, 3);
            $menus = Menu::inRandomOrder()->take($menuCount)->get();
            
            foreach ($menus as $menu) {
                OrderItem::factory()->create([
                    'order_id' => $order->id,
                    'menu_id' => $menu->id,
                ]);
            }
        }
        
        $this->command->info('✅ Order items seeded! Total: ' . OrderItem::count());
    }
}