<?php
// database/seeders/OperationalHoursSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OperationalHoursSeeder extends Seeder
{
    public function run(): void
    {
        $days = [
            ['day_of_week' => 0, 'day_name' => 'Sunday', 'is_open' => true, 'open_time' => '10:00', 'close_time' => '22:00'],
            ['day_of_week' => 1, 'day_name' => 'Monday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '22:00'],
            ['day_of_week' => 2, 'day_name' => 'Tuesday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '22:00'],
            ['day_of_week' => 3, 'day_name' => 'Wednesday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '22:00'],
            ['day_of_week' => 4, 'day_name' => 'Thursday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '22:00'],
            ['day_of_week' => 5, 'day_name' => 'Friday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '23:00'],
            ['day_of_week' => 6, 'day_name' => 'Saturday', 'is_open' => true, 'open_time' => '09:00', 'close_time' => '23:00'],
        ];
        
        foreach ($days as $day) {
            DB::table('operational_hours')->insert([
                'day_of_week' => $day['day_of_week'],
                'is_open' => $day['is_open'],
                'open_time' => $day['open_time'],
                'close_time' => $day['close_time'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        
        $this->command->info('✅ Operational hours seeded!');
    }
}