<?php
// database/seeders/JobPostingsSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\JobPosting;

class JobPostingsSeeder extends Seeder
{
    public function run(): void
    {
        // Create fixed job postings
        $fixedJobs = [
            [
                'title' => 'Head Chef',
                'department' => 'Kitchen',
                'location' => 'Jakarta',
                'employment_type' => 'full_time',
                'salary_range' => 'Rp 10.000.000 - Rp 15.000.000',
                'application_deadline' => now()->addDays(30),
                'is_active' => true,
            ],
            [
                'title' => 'Server Staff',
                'department' => 'Service',
                'location' => 'Bandung',
                'employment_type' => 'part_time',
                'salary_range' => 'Rp 3.000.000 - Rp 5.000.000',
                'application_deadline' => now()->addDays(14),
                'is_active' => true,
            ],
            [
                'title' => 'Marketing Manager',
                'department' => 'Marketing',
                'location' => 'Jakarta',
                'employment_type' => 'full_time',
                'salary_range' => 'Rp 8.000.000 - Rp 12.000.000',
                'application_deadline' => now()->addDays(45),
                'is_active' => true,
            ],
        ];
        
        foreach ($fixedJobs as $job) {
            JobPosting::create([
                ...$job,
                'description' => $this->generateDescription($job['title'], $job['department']),
                'requirements' => $this->generateRequirements($job['title']),
                'benefits' => $this->generateBenefits(),
                'views_count' => rand(50, 500),
            ]);
        }
        
        // Create random job postings
        JobPosting::factory()->count(8)->create();
        
        // Create some expired jobs
        JobPosting::factory()
            ->count(2)
            ->expired()
            ->create();
        
        $this->command->info('✅ Job postings seeded! Total: ' . JobPosting::count());
    }
    
    private function generateDescription($title, $department): string
    {
        return "We are looking for a talented $title to join our $department team at Chingu Bite. 
                The ideal candidate will have experience in Korean cuisine and restaurant operations. 
                You will be responsible for ensuring excellent service and quality food preparation.";
    }
    
    private function generateRequirements($title): string
    {
        return "1. Minimum 2 years experience in restaurant industry\n" .
               "2. Knowledge of Korean cuisine for $title position\n" .
               "3. Good communication skills\n" .
               "4. Able to work in team\n" .
               "5. Flexible working hours";
    }
    
    private function generateBenefits(): string
    {
        return "1. Competitive salary\n" .
               "2. Health insurance\n" .
               "3. Meal allowance\n" .
               "4. Training opportunities\n" .
               "5. Career growth";
    }
}