<?php
// database/seeders/CategoriesSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategoriesSeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Main Course', 'description' => 'Korean main dishes', 'image_url' => 'https://example.com/main-course.jpg'],
            ['name' => 'Appetizers', 'description' => 'Korean appetizers and starters', 'image_url' => 'https://example.com/appetizers.jpg'],
            ['name' => 'Desserts', 'description' => 'Korean desserts and sweets', 'image_url' => 'https://example.com/desserts.jpg'],
            ['name' => 'Drinks', 'description' => 'Korean beverages and drinks', 'image_url' => 'https://example.com/drinks.jpg'],
            ['name' => 'Street Food', 'description' => 'Korean street food', 'image_url' => 'https://example.com/street-food.jpg'],
            ['name' => 'Side Dishes', 'description' => 'Korean side dishes (banchan)', 'image_url' => 'https://example.com/side-dishes.jpg'],
        ];
        
        foreach ($categories as $category) {
            Category::create($category);
        }
        
        // Create additional random categories
        Category::factory()->count(4)->create();
        
        $this->command->info('✅ Categories seeded! Total: ' . Category::count());
    }
}