<?php
// database/seeders/AdditionalDataSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AdditionalDataSeeder extends Seeder
{
    public function run(): void
    {
        // Update some orders to have promo discounts
        $promos = \App\Models\Promo::where('is_active', true)->get();
        $orders = \App\Models\Order::inRandomOrder()->take(10)->get();
        
        foreach ($orders as $order) {
            if ($promos->isNotEmpty() && rand(0, 1)) {
                $promo = $promos->random();
                $discount = $this->calculateDiscount($promo, $order->total_amount);
                
                $order->update([
                    'discount_amount' => $discount,
                    'final_amount' => $order->final_amount - $discount,
                ]);
                
                // You could add a promo_usage table here
            }
        }
        
        // Update some menus based on popularity
        $popularMenus = \App\Models\Menu::inRandomOrder()->take(5)->get();
        foreach ($popularMenus as $menu) {
            $orderCount = \App\Models\OrderItem::where('menu_id', $menu->id)->count();
            
            if ($orderCount > 3) {
                $menu->update([
                    'is_best_seller' => true,
                    'stock' => $menu->stock > 20 ? $menu->stock : 50, // Restock if popular
                ]);
            }
        }
        
        // Create some low stock alerts
        $lowStockMenus = \App\Models\Menu::where('stock', '<', 10)
            ->where('is_available', true)
            ->get();
            
        foreach ($lowStockMenus as $menu) {
            $this->command->info("⚠️  Low stock alert: {$menu->name} - {$menu->stock} left");
        }
        
        $this->command->info('✅ Additional data processing completed!');
    }
    
    private function calculateDiscount($promo, $totalAmount): float
    {
        if ($promo->type === 'percentage') {
            $discount = $totalAmount * ($promo->discount_value / 100);
            
            if ($promo->max_discount && $discount > $promo->max_discount) {
                return $promo->max_discount;
            }
            
            return $discount;
        }
        
        if ($promo->type === 'fixed') {
            return $promo->discount_value;
        }
        
        // For BOGO, logic would be more complex
        return 0;
    }
}