<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('operational_hours', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('day_of_week')->unsigned()->check('day_of_week >= 0 AND day_of_week <= 6');
            $table->boolean('is_open')->default(true);
            $table->time('open_time');
            $table->time('close_time');
            $table->timestamps();
            
            $table->unique('day_of_week');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('operational_hours');
    }
};