<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    private static $emailCounter = 1000; // Start from high number to avoid conflict
    
    public function definition(): array
    {
        $roles = ['admin', 'employee', 'customer'];
        $role = $this->faker->randomElement($roles);
        
        // Generate unique email with timestamp
        self::$emailCounter++;
        $timestamp = time();
        
        return [
            'name' => $this->faker->name(),
            'email' => "user{$timestamp}_" . self::$emailCounter . "@chingubite.test",
            'phone' => '08' . $this->faker->unique()->numerify('##########'),
            'password' => Hash::make('password123'),
            'role' => $role,
            'email_verified_at' => now(),
            'remember_token' => Str::random(10),
            'created_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function admin(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'admin',
            'email' => 'admin' . time() . '@chingubite.test', // Make unique
        ]);
    }
    
    public function employee(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'employee',
            'email' => 'employee' . time() . '_' . rand(1000, 9999) . '@chingubite.test',
        ]);
    }
    
    public function customer(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'customer',
            'email' => 'customer' . time() . '_' . rand(1000, 9999) . '@chingubite.test',
        ]);
    }
    
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}