<?php
// database/factories/PromoFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class PromoFactory extends Factory
{
    public function definition(): array
    {
        $types = ['percentage', 'fixed', 'bogo'];
        $type = $this->faker->randomElement($types);
        
        $startDate = $this->faker->dateTimeBetween('-1 month', '+1 month');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 months');
        
        static $promoCounter = 0;
        $promoCounter++;
        
        return [
            'name' => $this->faker->words(3, true) . ' Promo',
            'description' => $this->faker->sentence(8),
            'type' => $type,
            'discount_value' => $type === 'percentage' 
                ? $this->faker->numberBetween(5, 50)
                : $this->faker->numberBetween(5000, 50000),
            'min_purchase' => $this->faker->optional(0.5)->numberBetween(50000, 200000),
            'max_discount' => $type === 'percentage' 
                ? $this->faker->optional(0.3)->numberBetween(10000, 50000)
                : null,
            'code' => 'PROMO' . str_pad($promoCounter, 3, '0', STR_PAD_LEFT),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'is_active' => $this->faker->boolean(70),
            'created_at' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
            'start_date' => now()->subDays(7),
            'end_date' => now()->addDays(30),
        ]);
    }
    
    public function expired(): static
    {
        return $this->state(fn (array $attributes) => [
            'end_date' => now()->subDays(7),
        ]);
    }
    
    public function percentage(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'percentage',
            'discount_value' => $this->faker->numberBetween(10, 30),
        ]);
    }
    
    public function fixed(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'fixed',
            'discount_value' => $this->faker->numberBetween(10000, 50000),
        ]);
    }
}