<?php
// database/factories/PaymentMethodFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class PaymentMethodFactory extends Factory
{
    public function definition(): array
    {
        $methods = [
            ['name' => 'Cash', 'code' => 'cash'],
            ['name' => 'Bank Transfer BCA', 'code' => 'bank_transfer'],
            ['name' => 'Bank Transfer Mandiri', 'code' => 'bank_transfer'],
            ['name' => 'OVO', 'code' => 'ewallet'],
            ['name' => 'GoPay', 'code' => 'ewallet'],
            ['name' => 'DANA', 'code' => 'ewallet'],
            ['name' => 'QRIS', 'code' => 'qris'],
            ['name' => 'Credit Card', 'code' => 'credit_card'],
        ];
        
        $method = $this->faker->randomElement($methods);
        
        return [
            'name' => $method['name'],
            'code' => $method['code'],
            'account_number' => $method['code'] === 'bank_transfer' 
                ? $this->faker->bankAccountNumber
                : null,
            'account_name' => $method['code'] === 'bank_transfer'
                ? $this->faker->name
                : null,
            'is_active' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
    
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }
}