<?php
// database/factories/OrderItemFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class OrderItemFactory extends Factory
{
    public function definition(): array
    {
        $quantity = $this->faker->numberBetween(1, 5);
        $unitPrice = $this->faker->numberBetween(15000, 120000);
        $subtotal = $quantity * $unitPrice;
        
        return [
            'order_id' => \App\Models\Order::factory(),
            'menu_id' => \App\Models\Menu::factory(),
            'quantity' => $quantity,
            'unit_price' => $unitPrice,
            'subtotal' => $subtotal,
            'notes' => $this->faker->optional(0.1)->sentence(),
            'rating' => $this->faker->optional(0.4)->numberBetween(1, 5),
            'review_comment' => function (array $attributes) {
                return $attributes['rating'] 
                    ? $this->faker->sentence(6)
                    : null;
            },
            'reviewed_at' => function (array $attributes) {
                return $attributes['rating'] 
                    ? $this->faker->dateTimeBetween('-3 months', 'now')
                    : null;
            },
            'created_at' => $this->faker->dateTimeBetween('-6 months', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function withReview(): static
    {
        return $this->state(fn (array $attributes) => [
            'rating' => $this->faker->numberBetween(3, 5),
            'review_comment' => $this->faker->sentence(6),
            'reviewed_at' => now(),
        ]);
    }
}