<?php
namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class MenuFactory extends Factory
{
    public function definition(): array
    {
        $koreanDishes = [
            'Bibimbap', 'Kimchi', 'Bulgogi', 'Tteokbokki', 'Japchae',
            'Samgyeopsal', 'Sundubu Jjigae', 'Gimbap', 'Haemul Pajeon',
            'Galbi', 'Naengmyeon', 'Bossam', 'Yukgaejang', 'Soy Sauce Crab'
        ];
        
        return [
            'category_id' => \App\Models\Category::factory(),
            'name' => $this->faker->randomElement($koreanDishes),
            'description' => $this->faker->paragraph(2),
            'price' => $this->faker->numberBetween(25000, 150000),
            'image_url' => $this->faker->imageUrl(400, 300, 'food', true, 'korean'),
            'stock' => $this->faker->numberBetween(0, 100),
            'is_available' => $this->faker->boolean(80),
            'is_special' => $this->faker->boolean(20),
            'is_best_seller' => $this->faker->boolean(30),
            'created_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function outOfStock(): static
    {
        return $this->state(fn (array $attributes) => [
            'stock' => 0,
            'is_available' => false,
        ]);
    }
    
    public function special(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_special' => true,
        ]);
    }
    
    public function bestSeller(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_best_seller' => true,
        ]);
    }
}