<?php
// database/factories/JobPostingFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class JobPostingFactory extends Factory
{
    public function definition(): array
    {
        $departments = ['Kitchen', 'Service', 'Management', 'Marketing', 'Finance'];
        $locations = ['Jakarta', 'Bandung', 'Surabaya', 'Bali', 'Remote'];
        $employmentTypes = ['full_time', 'part_time', 'contract', 'internship'];
        
        $deadline = $this->faker->dateTimeBetween('+1 week', '+3 months');
        
        return [
            'title' => $this->faker->jobTitle() . ' Specialist',
            'department' => $this->faker->randomElement($departments),
            'location' => $this->faker->randomElement($locations),
            'description' => $this->faker->paragraphs(3, true),
            'requirements' => $this->faker->paragraphs(5, true),
            'benefits' => $this->faker->paragraphs(2, true),
            'employment_type' => $this->faker->randomElement($employmentTypes),
            'salary_range' => $this->faker->optional(0.7)->passthrough(
                'Rp ' . number_format($this->faker->numberBetween(3000000, 15000000), 0, ',', '.') . ' - Rp ' . 
                number_format($this->faker->numberBetween(5000000, 20000000), 0, ',', '.')
            ),
            'application_deadline' => $deadline,
            'is_active' => $deadline > now(),
            'views_count' => $this->faker->numberBetween(0, 1000),
            'created_at' => $this->faker->dateTimeBetween('-6 months', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
            'application_deadline' => now()->addDays(30),
        ]);
    }
    
    public function expired(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
            'application_deadline' => now()->subDays(7),
        ]);
    }
}