<?php
// database/factories/JobApplicationFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class JobApplicationFactory extends Factory
{
    public function definition(): array
    {
        $statuses = ['pending', 'reviewed', 'interviewed', 'accepted', 'rejected'];
        
        return [
            'job_posting_id' => \App\Models\JobPosting::factory(),
            'applicant_name' => $this->faker->name(),
            'applicant_email' => $this->faker->unique()->safeEmail(),
            'applicant_phone' => '08' . $this->faker->unique()->numerify('##########'),
            'applicant_cv' => 'cvs/cv_' . $this->faker->uuid() . '.pdf',
            'cover_letter' => $this->faker->optional(0.7)->paragraphs(3, true),
            'status' => $this->faker->randomElement($statuses),
            'notes' => $this->faker->optional(0.3)->sentence(),
            'submitted_at' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'created_at' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'pending',
        ]);
    }
    
    public function accepted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'accepted',
        ]);
    }
}