<?php
// database/factories/CategoryFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class CategoryFactory extends Factory
{
    public function definition(): array
    {
        $koreanFoods = [
            'Main Course', 'Appetizers', 'Desserts', 'Drinks', 
            'Street Food', 'Side Dishes', 'Special Menu'
        ];
        
        return [
            'name' => $this->faker->randomElement($koreanFoods),
            'description' => $this->faker->sentence(10),
            'image_url' => $this->faker->imageUrl(400, 300, 'food', true, 'korean'),
            'is_active' => true,
            'created_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }
}