<?php
// database/factories/CartFactory.php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class CartFactory extends Factory
{
    public function definition(): array
    {
        return [
            'user_id' => \App\Models\User::factory()->customer(),
            'total_amount' => $this->faker->numberBetween(50000, 300000),
            'is_active' => $this->faker->boolean(70),
            'created_at' => $this->faker->dateTimeBetween('-1 month', 'now'),
            'updated_at' => now(),
        ];
    }
    
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }
    
    public function abandoned(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
            'created_at' => $this->faker->dateTimeBetween('-30 days', '-7 days'),
            'updated_at' => $this->faker->dateTimeBetween('-30 days', '-7 days'),
        ]);
    }
}