<?php
namespace App\Traits;

trait Searchable
{
    public function scopeSearch($query, $searchTerm, $searchableColumns = [])
    {
        if (empty($searchTerm) || empty($searchableColumns)) {
            return $query;
        }

        return $query->where(function ($query) use ($searchTerm, $searchableColumns) {
            foreach ($searchableColumns as $column) {
                $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
            }
        });
    }
}