<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property string $type
 * @property numeric $discount_value
 * @property numeric|null $min_purchase
 * @property numeric|null $max_discount
 * @property string|null $code
 * @property \Illuminate\Support\Carbon $start_date
 * @property \Illuminate\Support\Carbon $end_date
 * @property bool $is_active
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo active()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo byCode($code)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereDiscountValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereEndDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereMaxDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereMinPurchase($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereStartDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Promo whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Promo extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'type',
        'discount_value',
        'min_purchase',
        'max_discount',
        'code',
        'start_date',
        'end_date',
        'is_active',
    ];

    protected $casts = [
        'type' => 'string',
        'discount_value' => 'decimal:2',
        'min_purchase' => 'decimal:2',
        'max_discount' => 'decimal:2',
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'is_active' => 'boolean',
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true)
                    ->where('start_date', '<=', now())
                    ->where('end_date', '>=', now());
    }

    public function scopeByCode($query, $code)
    {
        return $query->where('code', $code);
    }

    // Helpers
    public function calculateDiscount($amount): float
    {
        if (!$this->is_active || now() < $this->start_date || now() > $this->end_date) {
            return 0;
        }

        if ($this->min_purchase && $amount < $this->min_purchase) {
            return 0;
        }

        $discount = 0;
        
        if ($this->type === 'percentage') {
            $discount = $amount * ($this->discount_value / 100);
            if ($this->max_discount && $discount > $this->max_discount) {
                $discount = $this->max_discount;
            }
        } elseif ($this->type === 'fixed') {
            $discount = $this->discount_value;
        }
        // Untuk 'bogo' perlu logika khusus

        return min($discount, $amount);
    }
}