<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $day_of_week
 * @property bool $is_open
 * @property \Illuminate\Support\Carbon $open_time
 * @property \Illuminate\Support\Carbon $close_time
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read string $day_name
 * @property-read string $formatted_hours
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereCloseTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereDayOfWeek($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereIsOpen($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereOpenTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|OperationalHour whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class OperationalHour extends Model
{
    use HasFactory;

    protected $fillable = [
        'day_of_week',
        'is_open',
        'open_time',
        'close_time',
    ];

    protected $casts = [
        'day_of_week' => 'integer',
        'is_open' => 'boolean',
        'open_time' => 'datetime:H:i',
        'close_time' => 'datetime:H:i',
    ];

    // Helpers
    public function getDayNameAttribute(): string
    {
        $days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
        return $days[$this->day_of_week] ?? 'Unknown';
    }

    public function isCurrentlyOpen(): bool
    {
        if (!$this->is_open) {
            return false;
        }

        $now = now();
        if ($now->dayOfWeek != $this->day_of_week) {
            return false;
        }

        $openTime = now()->setTimeFrom($this->open_time);
        $closeTime = now()->setTimeFrom($this->close_time);

        // Handle closing after midnight
        if ($closeTime < $openTime) {
            $closeTime->addDay();
        }

        return $now >= $openTime && $now <= $closeTime;
    }

    public function getFormattedHoursAttribute(): string
    {
        if (!$this->is_open) {
            return 'Tutup';
        }

        return $this->open_time->format('H:i') . ' - ' . $this->close_time->format('H:i');
    }
}