<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property string $title
 * @property string $department
 * @property string $location
 * @property string $description
 * @property string $requirements
 * @property string|null $benefits
 * @property string $employment_type
 * @property string|null $salary_range
 * @property int $application_deadline
 * @property bool $is_active
 * @property int $views_count
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\JobApplication> $applications
 * @property-read int|null $applications_count
 * @property-read mixed $days_remaining
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting active()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereApplicationDeadline($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereBenefits($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereDepartment($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereEmploymentType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereLocation($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereRequirements($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereSalaryRange($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobPosting whereViewsCount($value)
 * @mixin \Eloquent
 */
class JobPosting extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'department',
        'location',
        'description',
        'requirements',
        'benefits',
        'employment_type',
        'salary_range',
        'application_deadline',
        'is_active',
        'views_count',
    ];

    protected $casts = [
        'application_deadline' => 'datetime',
        'is_active' => 'boolean',
        'views_count' => 'integer',
        'application_deadline' => 'integer',
    ];

    public function applications()
    {
        return $this->hasMany(JobApplication::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true)
                    ->where('application_deadline', '>=', now());
    }

    public function getDaysRemainingAttribute()
{
    return max(0, $this->application_deadline->diffInDays(now(), false));
}

public function isUrgent()
{
    return $this->days_remaining <= 7;
}
}