<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $job_posting_id
 * @property string $applicant_name
 * @property string $applicant_email
 * @property string $applicant_phone
 * @property string $applicant_cv
 * @property string|null $cover_letter
 * @property string $status
 * @property string|null $notes
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read mixed $formatted_status
 * @property-read \App\Models\JobPosting $jobPosting
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereApplicantCv($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereApplicantEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereApplicantName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereApplicantPhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereCoverLetter($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereJobPostingId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereNotes($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|JobApplication whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class JobApplication extends Model
{
    use HasFactory;

    protected $fillable = [
        'job_posting_id',
        'applicant_name',
        'applicant_email',
        'applicant_phone',
        'applicant_cv',
        'cover_letter',
        'status',
        'notes',
    ];

    protected $casts = [
        'submitted_at' => 'datetime',
    ];

    public function jobPosting()
    {
        return $this->belongsTo(JobPosting::class);
    }

    public function getFormattedStatusAttribute()
{
    $statuses = [
        'pending' => 'Menunggu Review',
        'reviewed' => 'Direview',
        'interviewed' => 'Interview',
        'accepted' => 'Diterima',
        'rejected' => 'Ditolak',
        'withdrawn' => 'Ditarik',
    ];

    return $statuses[$this->status] ?? $this->status;
}
}