<?php
// app/Http/Resources/Api/PromoCollection.php
namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\ResourceCollection;

class PromoCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => PromoResource::collection($this->collection),
            'meta' => [
                'current_page' => $this->currentPage(),
                'last_page' => $this->lastPage(),
                'per_page' => $this->perPage(),
                'total' => $this->total(),
            ],
        ];
    }
}