<?php
// app/Http/Resources/Api/JobPostingCollection.php
namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\ResourceCollection;

class JobPostingCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => JobPostingResource::collection($this->collection),
            'meta' => [
                'current_page' => $this->currentPage(),
                'last_page' => $this->lastPage(),
                'per_page' => $this->perPage(),
                'total' => $this->total(),
            ],
        ];
    }
}