<?php
// app/Http/Resources/Api/Employee/EmployeeResource.php
namespace App\Http\Resources\Api\Employee;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EmployeeResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'role' => $this->role,
            'formatted_role' => $this->getFormattedRole(),
            'email_verified_at' => $this->email_verified_at?->format('Y-m-d H:i:s'),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'permissions' => $this->getPermissions(),
        ];
    }

    private function getFormattedRole(): string
    {
        return match($this->role) {
            'admin' => 'Administrator',
            'employee' => 'Pegawai',
            default => $this->role,
        };
    }

    private function getPermissions(): array
    {
        $permissions = [];

        if ($this->role === 'admin') {
            $permissions = [
                'manage_orders' => true,
                'confirm_payments' => true,
                'manage_menu' => true,
                'manage_users' => true,
                'view_reports' => true,
            ];
        } else {
            $permissions = [
                'manage_orders' => true,
                'confirm_payments' => true,
                'view_orders' => true,
                'update_order_status' => true,
            ];
        }

        return $permissions;
    }
}