<?php

namespace App\Http\Resources\Api\Customer;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentMethodResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'account_number' => $this->account_number,
            'account_name' => $this->account_name,
            'requires_proof' => in_array($this->code, ['bank_transfer', 'ewallet']),
            'instructions' => $this->instructions,
        ];
    }

    private function getInstructions(): string
    {
        return match ($this->code) {
            'cash' => 'Bayar langsung di kasir saat mengambil pesanan',
            'bank_transfer' => "Transfer ke {$this->account_number} a.n {$this->account_name}. Upload bukti transfer setelah pembayaran.",
            'ewallet' => "Bayar melalui {$this->name} - {$this->account_number}. Upload bukti pembayaran.",
            'qris' => 'Scan QRIS yang tersedia di kasir atau aplikasi',
            'credit_card' => 'Bayar dengan kartu kredit di tempat atau online',
            default => 'Silakan hubungi kasir untuk instruksi pembayaran',
        };
    }
}