<?php

namespace App\Http\Resources\Api\Customer;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\Customer\OrderItemResource;

class OrderResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'order_number' => $this->order_number,
            'order_type' => $this->order_type,
            'formatted_order_type' => $this->getFormattedOrderType(),
            'status' => $this->status,
            'formatted_status' => $this->getFormattedStatus(),
            'status_badge' => $this->getStatusBadge(),
            'total_amount' => (float) $this->total_amount,
            'formatted_total_amount' => 'Rp ' . number_format($this->total_amount, 0, ',', '.'),
            'tax_amount' => (float) $this->tax_amount,
            'service_fee' => (float) $this->service_fee,
            'discount_amount' => (float) $this->discount_amount,
            'final_amount' => (float) $this->final_amount,
            'formatted_final_amount' => 'Rp ' . number_format($this->final_amount, 0, ',', '.'),
            'table_number' => $this->table_number,
            'notes' => $this->notes,
            'scheduled_for' => $this->scheduled_for?->scheduled_for->format('Y-m-d H:i:s'),
            'items' => orderItemResource::collection($this->whenLoaded('items')),
            'payments' => $this->whenLoaded('payments', function () {
                return $this->payment->first();
            }),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
    
    private function getFormattedOrderType(): string
    {
        return match ($this->order_type) {
            'dine_in' => 'Makan di Tempat',
            'takeaway' => 'Bawa Pulang',
            'delivery' => 'Delivery',
            default => $this->order_type,
        };
    }

    private function getFormattedStatus(): string
    {
        return match ($this->status) {
            'pending' => 'Menunggu Konfirmasi',
            'confirmed' => 'Dikonfirmasi',
            'preparing' => 'Sedang Disiapkan',
            'ready' => 'Siap Diambil',
            'completed' => 'Selesai',
            'cancelled' => 'Dibatalkan',
            default => $this->status,
        };
    }

}
