<?php
namespace App\Http\Resources\Api\Customer;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'menu_id' => $this->menu_id,
            'menu_name' => $this->menu->name ?? null,
            'menu_image' => $this->menu->image_url ?? null,
            'quantity' => $this->quantity,
            'unit_price' => (float) $this->unit_price,
            'formatted_unit_price' => 'Rp ' . number_format($this->unit_price, 0, ',', '.'),
            'subtotal' => (float) $this->subtotal,
            'formatted_subtotal' => 'Rp ' . number_format($this->subtotal, 0, ',', '.'),
            'notes' => $this->notes,
            'can_review' => !$this->rating && $this->order->status === 'completed',
            'rating' => $this->rating,
            'review_comment' => $this->review_comment,
            'reviewed_at' => $this->reviewed_at?->format('Y-m-d H:i:s'),
        ];
    }
}