<?php

namespace App\Http\Resources\Api\Customer;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MenuResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'price' => (float) $this->price,
            'formatted_price' => 'Rp ' . number_format($this->price, 0, ',', '.'),
            'image_url' => $this->image_url,
            'stock' => $this->stock,
            'is_available' => $this->is_available,
            'is_special' => $this->is_special,
            'is_best_seller' => $this->is_best_seller,
            'category' => $this->whenLoaded('category', function () {
                return [
                    'id' => $this->category->id,
                    'name' => $this->category->name,
                ];
            }) ,
            'average_rating' => $this->average_rating,
            'review_count' => $this->whenLoaded('reviews', function () {
                return $this->reviews->count();
            }),
            'recent_reviews' => $this->whenLoaded('reviews', function () {
                return $this->reviews->map(function ($review) {
                    return [
                        'rating' => $review->rating,
                        'comment' => $review->comment,
                        'customer_name' => $review->customer_name ?? 'Anonymous',
                        'created_at' => $review->created_at->format('Y-m-d H:i:s'),
                    ];
                });
            }),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
}