<?php

namespace App\Http\Resources\Api\Customer;

use Illuminate\Http\Resources\Json\JsonResource;

class JobPostingResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'department' => $this->department,
            'location' => $this->location,
            'employment_type' => $this->employment_type,
            'formatted_employment_type' => $this->getFormattedEmploymentType(),
            'description' => $this->description,
            'requirements' => $this->requirements,
            'benefits' => $this->benefits,
            'salary_range' => $this->salary_range,
            'application_deadline' => $this->application_deadline->format('Y-m-d'),
            'formatted_deadline' => $this->application_deadline->format('d F Y'),
            'days_remaining' => max(0, $this->application_deadline->diffInDays(now(), false)),
            'is_urgent' => $this->application_deadline->diffInDays(now()) <= 7,
            'views_count' => $this->views_count,
            'application_count' => $this->application_count,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'status' => $this->is_active && $this->application_deadline >= now() 
                ? 'active' 
                : 'closed',
        ];
    }

    private function getFormattedEmploymentType(): string
    {
        return match($this->employment_type) {
            'full_time' => 'Full Time',
            'part_time' => 'Part Time',
            'contract' => 'Kontrak',
            'internship' => 'Magang',
            default => $this->employment_type,
        };
    }
}