<?php

namespace App\Http\Resources\Api\Customer;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'image_url' => $this->image_url,
            'is_active' => $this->is_active,
            'menu_count' => $this->whenCounted('menus', function () {
                return $this->menus_count;
            }),
            'available_menu_count' => $this->whenLoaded('menus', function () {
                return $this->menus->where('is_available', true)->count();
            }),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
}