<?php
namespace App\Http\Resources\Api\Customer;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'menu_id' => $this['menu_id'],
            'menu_name' => $this['menu']['name'] ?? null,
            'menu_price' => $this['menu']['price'] ?? 0,
            'formatted_price' => isset($this['menu']['price']) ? 'Rp ' . number_format($this['menu']['price'], 0, ',', '.') : 'Rp 0',
            'menu_image' => $this['menu']['image_url'] ?? null,
            'quantity' => $this['quantity'],
            'notes' => $this['notes'] ?? null,
            'subtotal' => $this['subtotal'] ?? 0,
            'formatted_subtotal' => isset($this['subtotal']) ? 'Rp ' . number_format($this['subtotal'], 0, ',', '.') : 'Rp 0',
            'is_available' => $this->getIsAvailable(),
            'availability_message' => $this->getAvailabilityMessage(),
        ];
    }

    private function getIsAvailable(): bool
    {
        if (!isset($this['menu']['id'])) {
            return false;
        }

        // In real implementation, you might want to check menu availability
        return true;
    }

    private function getAvailabilityMessage(): string
    {
        if (!$this->getIsAvailable()) {
            return 'Menu tidak tersedia';
        }
        
        // You can add stock check here if needed
        return 'Tersedia';
    }
}